/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3920;
import net.minecraft.class_3956;

public class BookCampfireCookingRecipePage extends BookProcessingRecipePage<class_3920> {
    public BookCampfireCookingRecipePage(BookTextHolder title1, class_2960 recipeId1, BookTextHolder title2, class_2960 recipeId2, BookTextHolder text, String anchor, BookCondition condition) {
        super(class_3956.field_17549, title1, recipeId1, title2, recipeId2, text, anchor, condition);
    }

    public static BookCampfireCookingRecipePage fromJson(JsonObject json) {
        var common = BookRecipePage.commonFromJson(json);
        var anchor = class_3518.method_15253(json, "anchor", "");
        var condition = json.has("condition")
                ? BookCondition.fromJson(json.getAsJsonObject("condition"))
                : new BookNoneCondition();
        return new BookCampfireCookingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    public static BookCampfireCookingRecipePage fromNetwork(class_2540 buffer) {
        var common = BookRecipePage.commonFromNetwork(buffer);
        var anchor = buffer.method_19772();
        var condition = BookCondition.fromNetwork(buffer);
        return new BookCampfireCookingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    @Override
    public class_2960 getType() {
        return Page.CAMPFIRE_COOKING_RECIPE;
    }
}
