/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_8059;

public class BookSmithingRecipePage extends BookRecipePage<class_8059> {
    public BookSmithingRecipePage(BookTextHolder title1, class_2960 recipeId1, BookTextHolder title2, class_2960 recipeId2, BookTextHolder text, String anchor, BookCondition condition) {
        super(class_3956.field_25388, title1, recipeId1, title2, recipeId2, text, anchor, condition);
    }

    public static BookSmithingRecipePage fromJson(JsonObject json) {
        var common = BookRecipePage.commonFromJson(json);
        var anchor = class_3518.method_15253(json, "anchor", "");
        var condition = json.has("condition")
                ? BookCondition.fromJson(json.getAsJsonObject("condition"))
                : new BookNoneCondition();
        return new BookSmithingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    public static BookSmithingRecipePage fromNetwork(class_2540 buffer) {
        var common = BookRecipePage.commonFromNetwork(buffer);
        var anchor = buffer.method_19772();
        var condition = BookCondition.fromNetwork(buffer);
        return new BookSmithingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    @Override
    public class_2960 getType() {
        return Page.SMITHING_RECIPE;
    }

    @Override
    protected class_1799 getRecipeOutput(class_1937 level, class_8059 recipe) {
        if (recipe == null) {
            return class_1799.field_8037;
        }

        return recipe.method_8110(level.method_30349());
    }
}
