/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.bookstate.visual;

import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public class CategoryVisualState {

    public static final Codec<CategoryVisualState> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codecs.mutableMap(class_2960.field_25139, EntryVisualState.CODEC).fieldOf("entryStates").forGetter((state) -> state.entryStates),
            Codec.FLOAT.fieldOf("scrollX").forGetter((state) -> state.scrollX),
            Codec.FLOAT.fieldOf("scrollY").forGetter((state) -> state.scrollY),
            Codec.FLOAT.fieldOf("targetZoom").forGetter((state) -> state.targetZoom),
            class_2960.field_25139.optionalFieldOf("openEntry").forGetter((state) -> Optional.ofNullable(state.openEntry))
    ).apply(instance, CategoryVisualState::new));

    public Map<class_2960, EntryVisualState> entryStates;

    public float scrollX;
    public float scrollY;
    public float targetZoom;

    public class_2960 openEntry;

    public CategoryVisualState() {
        this(new Object2ObjectOpenHashMap<>(), 0, 0, 0.7f, Optional.empty());
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public CategoryVisualState(Map<class_2960, EntryVisualState> entryStates, float scrollX, float scrollY, float targetZoom, Optional<class_2960> openEntry) {
        this.entryStates = entryStates;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.targetZoom = targetZoom;
        this.openEntry = openEntry.orElse(null);
    }
}
