/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 * SPDX-FileCopyrightText: 2021 Authors of Patchouli
 *
 * SPDX-License-Identifier: MIT
 */


package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.book.entries.*;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookSearchScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

public class EntryListButton extends class_4185 {

    private static final int ANIM_TIME = 5;

    private final BookSearchScreen parent;
    private final BookEntry entry;
    private float timeHovered;

    public EntryListButton(BookSearchScreen parent, BookEntry entry, int pX, int pY, class_4241 pOnPress) {
        super(pX, pY, BookContentScreen.PAGE_WIDTH, 10, class_2561.method_43471(entry.getName()), pOnPress, class_4185.field_40754);

        this.parent = parent;
        this.entry = entry;
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    private int getEntryColor() {
        return 0x000000;
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22763) {
            if (this.method_49606()) {
                this.timeHovered = Math.min(ANIM_TIME, this.timeHovered + ClientTicks.delta);
            } else {
                this.timeHovered = Math.max(0, this.timeHovered - ClientTicks.delta);
            }

            float time = Math.max(0, Math.min(ANIM_TIME, this.timeHovered + (this.method_49606() ? partialTicks : -partialTicks)));
            float widthFract = time / ANIM_TIME;
            boolean locked = !BookUnlockStateManager.get().isUnlockedFor(class_310.method_1551().field_1724, this.entry);

            guiGraphics.method_51448().method_22905(0.5F, 0.5F, 0.5F);
            guiGraphics.method_25294(this.method_46426() * 2, this.method_46427() * 2, (this.method_46426() + (int) ((float) this.field_22758 * widthFract)) * 2, (this.method_46427() + this.field_22759) * 2, 0x22000000);
            RenderSystem.enableBlend();

            if (locked) {
                RenderSystem.setShaderColor(1F, 1F, 1F, 0.7F);
                BookContentScreen.drawLock(guiGraphics, this.parent.getParentScreen().getBook(), this.method_46426() * 2 + 2, this.method_46427() * 2 + 2);
            } else {
                this.entry.getIcon().render(guiGraphics, this.method_46426() * 2 + 2, this.method_46427() * 2 + 2);
            }

            guiGraphics.method_51448().method_22905(2F, 2F, 2F);

            class_5250 name;
            if (locked) {
                name = class_2561.method_43471(Gui.SEARCH_ENTRY_LOCKED);
            } else {
                name = class_2561.method_43471(this.entry.getName());
            }

            //TODO: if we ever add a font style setting to the book, use it here
            guiGraphics.method_51439(class_310.method_1551().field_1772, name, this.method_46426() + 12, this.method_46427(), this.getEntryColor(), false);
        }
    }

    @Override
    public void method_25354(class_1144 soundHandlerIn) {
        if (this.entry != null) {
            //TODO: play flip sound
        }
    }


}
