/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.network;

import com.klikli_dev.modonomicon.networking.Message;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;
import java.util.function.Function;

public class ClientMessageHandler<T extends Message> implements ClientPlayNetworking.PlayChannelHandler {

    private final Function<class_2540, T> decoder;

    public ClientMessageHandler(Function<class_2540, T> decoder) {
        this.decoder = decoder;
    }

    @Override
    public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        var packet = this.decoder.apply(buf);

        client.execute(() -> {
            packet.onClientReceived(client, client.field_1724);
        });
    }
}