/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BookEntryReadMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "book_entry_read");

    public class_2960 bookId;
    public class_2960 entryId;

    public BookEntryReadMessage(class_2960 bookId, class_2960 entryId) {
        this.bookId = bookId;
        this.entryId = entryId;
    }

    public BookEntryReadMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10812(this.bookId);
        buf.method_10812(this.entryId);
    }

    @Override
    public void decode(class_2540 buf) {
        this.bookId = buf.method_10810();
        this.entryId = buf.method_10810();
    }


    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var entry = BookDataManager.get().getBook(this.bookId).getEntry(this.entryId);
        //unlock page, then update the unlock capability, finally sync.
        if (BookUnlockStateManager.get().readFor(player, entry)) {
            BookUnlockStateManager.get().updateAndSyncFor(player);
        }
    }
}
