/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum PageDisplayMode implements StringRepresentable
{
    DOUBLE_PAGE("double_page"),
    SINGLE_PAGE("single_page");

    public static final StringRepresentable.EnumCodec<PageDisplayMode> CODEC;
    private static final IntFunction<PageDisplayMode> BY_ID;
    public static final StreamCodec<ByteBuf, PageDisplayMode> STREAM_CODEC;
    private final String name;

    private PageDisplayMode(String name) {
        this.name = name;
    }

    public static PageDisplayMode byName(String pName) {
        return (PageDisplayMode)CODEC.byName(pName);
    }

    public static PageDisplayMode byId(int pId) {
        return BY_ID.apply(pId);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(PageDisplayMode::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])PageDisplayMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

