/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.fluid;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidRenderHelper {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;

    public static void drawFluid(GuiGraphics guiGraphics, int width, int height, FluidStack fluidStack, int capacity, int x, int y) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid.isSame(Fluids.EMPTY)) {
            return;
        }
        FluidRenderHelper.getStillFluidSprite(fluidStack).ifPresent(fluidStillSprite -> {
            int fluidColor = FluidRenderHelper.getColorTint(fluidStack);
            int amount = fluidStack.getAmount();
            int scaledAmount = amount * height / capacity;
            if (amount > 0 && scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > height) {
                scaledAmount = height;
            }
            GuiGraphicsExt.drawTiledSprite(guiGraphics, width, height, fluidColor, scaledAmount, fluidStillSprite, x, y);
        });
    }

    private static int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    private static Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(fluidStill);
        return Optional.of(sprite).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation());
    }

    public static List<Component> getTooltip(FluidStack fluidStack, int capacity, TooltipFlag tooltipFlag, FluidHelper.TooltipMode tooltipMode) {
        Fluid fluidType = fluidStack.getFluid();
        try {
            if (fluidType.isSame(Fluids.EMPTY)) {
                return new ArrayList<Component>();
            }
            List<Component> tooltip = FluidRenderHelper.getTooltipBase(fluidStack, tooltipFlag);
            long amount = fluidStack.getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                MutableComponent amountString = Component.translatable((String)"tooltip.modonomicon.fluid.amount_and_capacity", (Object[])new Object[]{milliBuckets, capacity});
                tooltip.add((Component)amountString.withStyle(ChatFormatting.GRAY));
            } else if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT) {
                MutableComponent amountString = Component.translatable((String)"tooltip.modonomicon.fluid.amount", (Object[])new Object[]{milliBuckets});
                tooltip.add((Component)amountString.withStyle(ChatFormatting.GRAY));
            }
            return tooltip;
        }
        catch (RuntimeException e) {
            Component displayName = fluidStack.getHoverName();
            Modonomicon.LOG.error("Failed to get tooltip for fluid: " + String.valueOf(displayName), (Throwable)e);
            return new ArrayList<Component>();
        }
    }

    private static List<Component> getTooltipBase(FluidStack fluidStack, TooltipFlag tooltipFlag) {
        ResourceLocation resourceLocation;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluid = fluidStack.getFluid();
        if (fluid.isSame(Fluids.EMPTY)) {
            return tooltip;
        }
        Component displayName = fluidStack.getHoverName();
        tooltip.add(displayName);
        if (tooltipFlag.isAdvanced() && (resourceLocation = BuiltInRegistries.FLUID.getKey((Object)fluid)) != null) {
            MutableComponent advancedId = Component.literal((String)resourceLocation.toString()).withStyle(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)advancedId);
        }
        return tooltip;
    }
}

