/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Player;

public class CategoryListButton
extends Button {
    private static final int ANIM_TIME = 5;
    private final BookCategory category;
    private float timeHovered;

    public CategoryListButton(BookCategory category, int pX, int pY, Button.OnPress pOnPress) {
        super(pX, pY, 124, 10, (Component)Component.translatable((String)category.getName()), pOnPress, Button.DEFAULT_NARRATION);
        this.category = category;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    private int getEntryColor() {
        return -16777216;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.active) {
            this.timeHovered = this.isHovered() ? Math.min(5.0f, this.timeHovered + ClientTicks.delta) : Math.max(0.0f, this.timeHovered - ClientTicks.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.isHovered() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = !BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.getInstance().player, this.category);
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().scale(0.5f, 0.5f);
            guiGraphics.fill(this.getX() * 2, this.getY() * 2, (this.getX() + (int)((float)this.width * widthFract)) * 2, (this.getY() + this.height) * 2, 0x22000000);
            if (locked) {
                int color = ARGB.colorFromFloat((float)0.7f, (float)1.0f, (float)1.0f, (float)1.0f);
                BookContentRenderer.drawLock(guiGraphics, this.category.getBook(), this.getX() * 2 + 2, this.getY() * 2 + 2, color);
            } else {
                this.category.getIcon().render(guiGraphics, this.getX() * 2 + 2, this.getY() * 2 + 2);
            }
            guiGraphics.pose().scale(2.0f, 2.0f);
            guiGraphics.pose().popMatrix();
            MutableComponent name = locked ? Component.translatable((String)"modonomicon.gui.search.entry.locked") : Component.translatable((String)this.category.getName());
            name.withStyle(style -> style.withFont(BookDataManager.Client.get().safeFont(this.category.getBook().getFont())));
            int x = this.getX() + 12;
            int y = this.getY() + 2;
            int maxWidth = 112;
            guiGraphics.pose().pushMatrix();
            float scale = Math.min(1.0f, (float)maxWidth / (float)Minecraft.getInstance().font.width((FormattedText)name));
            if (scale < 1.0f) {
                guiGraphics.pose().translate((float)x - (float)x * scale, (float)y - (float)y * scale);
                guiGraphics.pose().scale(scale, scale);
            }
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)name, x, y, this.getEntryColor(), false);
            guiGraphics.pose().popMatrix();
        }
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        if (this.category != null) {
            // empty if block
        }
    }
}

