/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import java.util.function.Consumer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;

public class PatchouliLinkRenderer
implements LinkRenderer {
    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (PatchouliLink.isPatchouliLink(link.getDestination())) {
            TextColor currentColor = context.getCurrentStyle().getColor();
            BookErrorManager.get().setContext("Link: {}, \n{}", link.getDestination(), BookErrorManager.get().getContextHelper());
            PatchouliLink patchoulLink = PatchouliLink.from(link.getDestination());
            String goToText = "patchouli." + patchoulLink.bookId.toString().replace(":", ".").replace("/", ".") + "." + patchoulLink.entryId.getPath().replace(":", ".").replace("/", ".") + ".name";
            MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.book_link", (Object[])new Object[]{Component.translatable((String)goToText)});
            context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor == null ? context.getLinkColor() : currentColor).withClickEvent((ClickEvent)new ClickEvent.OpenFile(link.getDestination())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hoverComponent)));
            visitChildren.accept((Node)link);
            context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor).withClickEvent(null).withHoverEvent(null));
            BookErrorManager.get().setContext(null, new Object[0]);
            return true;
        }
        return false;
    }
}

