/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BookRecipePage<T extends Recipe<?>>
extends BookPage {
    protected BookTextHolder title1;
    protected ResourceKey<Recipe<?>> recipeKey1;
    @Nullable
    protected RecipeDisplayEntry recipeDisplayEntry1;
    protected BookTextHolder title2;
    protected ResourceKey<Recipe<?>> recipeKey2;
    @Nullable
    protected RecipeDisplayEntry recipeDisplayEntry2;
    protected BookTextHolder text;

    public BookRecipePage(JsonDataHolder common) {
        this(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), common.anchor(), common.condition());
    }

    public BookRecipePage(NetworkDataHolder common) {
        this(common.title1(), common.recipeKey1(), common.recipeDisplayEntry1(), common.title2(), common.recipeKey2(), common.recipeDisplayEntry2(), common.text(), common.anchor(), common.condition());
    }

    private BookRecipePage(BookTextHolder title1, ResourceKey<Recipe<?>> recipeKey1, BookTextHolder title2, ResourceKey<Recipe<?>> recipeKey2, BookTextHolder text, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title1 = title1;
        this.recipeKey1 = recipeKey1;
        this.title2 = title2;
        this.recipeKey2 = recipeKey2;
        this.text = text;
    }

    private BookRecipePage(BookTextHolder title1, ResourceKey<Recipe<?>> recipeKey1, @Nullable RecipeDisplayEntry recipeDisplayEntry1, BookTextHolder title2, ResourceKey<Recipe<?>> recipeKey2, @Nullable RecipeDisplayEntry recipeDisplayEntry2, BookTextHolder text, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title1 = title1;
        this.recipeKey1 = recipeKey1;
        this.recipeDisplayEntry1 = recipeDisplayEntry1;
        this.title2 = title2;
        this.recipeKey2 = recipeKey2;
        this.recipeDisplayEntry2 = recipeDisplayEntry2;
        this.text = text;
    }

    public static JsonDataHolder commonFromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title1 = BookGsonHelper.getAsBookTextHolder(json, "title1", BookTextHolder.EMPTY, provider);
        ResourceLocation recipeId1 = json.has("recipe_id_1") ? ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"recipe_id_1")) : null;
        ResourceKey recipeKey1 = recipeId1 != null ? ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId1) : null;
        BookTextHolder title2 = BookGsonHelper.getAsBookTextHolder(json, "title2", BookTextHolder.EMPTY, provider);
        ResourceLocation recipeId2 = json.has("recipe_id_2") ? ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"recipe_id_2")) : null;
        ResourceKey recipeKey2 = recipeId2 != null ? ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId2) : null;
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson(entryId, json.getAsJsonObject("condition"), provider) : new BookNoneCondition();
        return new JsonDataHolder(title1, recipeKey1, title2, recipeKey2, text, anchor, condition);
    }

    public static NetworkDataHolder commonFromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title1 = BookTextHolder.fromNetwork(buffer);
        ResourceKey recipeKey1 = buffer.readBoolean() ? buffer.readResourceKey(Registries.RECIPE) : null;
        RecipeDisplayEntry recipeDisplayEntry1 = buffer.readBoolean() ? (RecipeDisplayEntry)RecipeDisplayEntry.STREAM_CODEC.decode((Object)buffer) : null;
        BookTextHolder title2 = BookTextHolder.fromNetwork(buffer);
        ResourceKey recipeKey2 = buffer.readBoolean() ? buffer.readResourceKey(Registries.RECIPE) : null;
        RecipeDisplayEntry recipeDisplayEntry2 = buffer.readBoolean() ? (RecipeDisplayEntry)RecipeDisplayEntry.STREAM_CODEC.decode((Object)buffer) : null;
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new NetworkDataHolder(title1, recipeKey1, recipeDisplayEntry1, title2, recipeKey2, recipeDisplayEntry2, text, anchor, condition);
    }

    public BookTextHolder getTitle1() {
        return this.title1;
    }

    public ResourceKey<Recipe<?>> getRecipeKey1() {
        return this.recipeKey1;
    }

    @Nullable
    public RecipeDisplayEntry getRecipeDisplayEntry1() {
        return this.recipeDisplayEntry1;
    }

    public BookTextHolder getTitle2() {
        return this.title2;
    }

    public ResourceKey<Recipe<?>> getRecipeKey2() {
        return this.recipeKey2;
    }

    @Nullable
    public RecipeDisplayEntry getRecipeDisplayEntry2() {
        return this.recipeDisplayEntry2;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    protected ItemStack getRecipeOutput(Level level, RecipeDisplayEntry recipeDisplayEntry) {
        if (recipeDisplayEntry == null) {
            ItemStack item = new ItemStack((ItemLike)Items.BARRIER);
            item.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Recipe not found, please check the logs."));
            return item;
        }
        List results = recipeDisplayEntry.resultItems(SlotDisplayContext.fromLevel((Level)level));
        return results.stream().findFirst().orElse(ItemStack.EMPTY);
    }

    private RecipeDisplayEntry getRecipeDisplayEntry(ServerLevel serverLevel, ResourceKey<Recipe<?>> key) {
        if (key == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        serverLevel.recipeAccess().listDisplaysForRecipe(key, list::add);
        RecipeDisplayEntry entry = list.stream().findFirst().orElse(null);
        if (entry == null) {
            Modonomicon.LOG.warn("Recipe {} not found.", key);
        }
        return entry;
    }

    @Override
    public void build(Level level, BookContentEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.recipeDisplayEntry1 = this.getRecipeDisplayEntry(serverLevel, this.recipeKey1);
            this.recipeDisplayEntry2 = this.getRecipeDisplayEntry(serverLevel, this.recipeKey2);
        }
        if (this.recipeDisplayEntry1 == null && this.recipeDisplayEntry2 != null) {
            this.recipeDisplayEntry1 = this.recipeDisplayEntry2;
            this.recipeDisplayEntry2 = null;
        }
        if (this.title1.isEmpty()) {
            this.title1 = new BookTextHolder((Component)((MutableComponent)this.getRecipeOutput(level, this.recipeDisplayEntry1).getHoverName()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.recipeDisplayEntry2 != null && this.title2.isEmpty()) {
            this.title2 = new BookTextHolder((Component)((MutableComponent)this.getRecipeOutput(level, this.recipeDisplayEntry2).getHoverName()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.title1.equals(this.title2)) {
            this.title2 = BookTextHolder.EMPTY;
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title1.hasComponent()) {
            this.title1 = new BookTextHolder((Component)Component.translatable((String)this.title1.getKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.title2.hasComponent()) {
            this.title2 = new BookTextHolder((Component)Component.translatable((String)this.title2.getKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        this.title1.toNetwork(buffer);
        buffer.writeBoolean(this.recipeKey1 != null);
        if (this.recipeKey1 != null) {
            buffer.writeResourceKey(this.recipeKey1);
        }
        buffer.writeBoolean(this.recipeDisplayEntry1 != null);
        if (this.recipeDisplayEntry1 != null) {
            RecipeDisplayEntry.STREAM_CODEC.encode((Object)buffer, (Object)this.recipeDisplayEntry1);
        }
        this.title2.toNetwork(buffer);
        buffer.writeBoolean(this.recipeKey2 != null);
        if (this.recipeKey2 != null) {
            buffer.writeResourceKey(this.recipeKey2);
        }
        buffer.writeBoolean(this.recipeDisplayEntry2 != null);
        if (this.recipeDisplayEntry2 != null) {
            RecipeDisplayEntry.STREAM_CODEC.encode((Object)buffer, (Object)this.recipeDisplayEntry2);
        }
        this.text.toNetwork(buffer);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query, Level level) {
        return this.title1.getString().toLowerCase().contains(query) || this.title2.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }

    public record JsonDataHolder(BookTextHolder title1, ResourceKey<Recipe<?>> recipeId1, BookTextHolder title2, ResourceKey<Recipe<?>> recipeId2, BookTextHolder text, String anchor, BookCondition condition) {
    }

    public record NetworkDataHolder(BookTextHolder title1, ResourceKey<Recipe<?>> recipeKey1, RecipeDisplayEntry recipeDisplayEntry1, BookTextHolder title2, ResourceKey<Recipe<?>> recipeKey2, RecipeDisplayEntry recipeDisplayEntry2, BookTextHolder text, String anchor, BookCondition condition) {
    }
}

