/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui;

import com.klikli_dev.modonomicon.api.events.EntryFirstReadEvent;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.book.PageDisplayMode;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.CategoryLinkBookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookErrorScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryDoublePageScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntrySinglePageScreen;
import com.klikli_dev.modonomicon.client.gui.book.index.BookCategoryIndexOnNodeScreen;
import com.klikli_dev.modonomicon.client.gui.book.index.BookCategoryIndexScreen;
import com.klikli_dev.modonomicon.client.gui.book.index.BookParentIndexScreen;
import com.klikli_dev.modonomicon.client.gui.book.node.BookCategoryNodeScreen;
import com.klikli_dev.modonomicon.client.gui.book.node.BookParentNodeScreen;
import com.klikli_dev.modonomicon.client.gui.book.node.DummyBookCategoryNodeScreen;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.events.ModonomiconEvents;
import com.klikli_dev.modonomicon.item.ModonomiconItem;
import com.klikli_dev.modonomicon.networking.BookClosedMessage;
import com.klikli_dev.modonomicon.networking.BookEntryReadMessage;
import com.klikli_dev.modonomicon.networking.SaveBookStateMessage;
import com.klikli_dev.modonomicon.networking.SaveCategoryStateMessage;
import com.klikli_dev.modonomicon.networking.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BookGuiManager {
    private static final BookGuiManager instance = new BookGuiManager();
    private final Map<ResourceLocation, Stack<BookAddress>> history = new Object2ObjectArrayMap();
    public BookParentScreen openBookParentScreen;
    public BookCategoryScreen openBookCategoryScreen;
    public BookEntryScreen openBookEntryScreen;

    private BookGuiManager() {
    }

    public static BookGuiManager get() {
        return instance;
    }

    protected boolean showErrorScreen(ResourceLocation bookId) {
        if (BookErrorManager.get().hasErrors(bookId)) {
            Book book = BookDataManager.get().getBook(bookId);
            Minecraft.getInstance().setScreen((Screen)new BookErrorScreen(book));
            return true;
        }
        return false;
    }

    protected void safeguardBooksBuilt() {
        if (!BookDataManager.get().areBooksBuilt()) {
            BookDataManager.get().registries((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            BookDataManager.get().tryBuildBooks((Level)Minecraft.getInstance().level);
            BookDataManager.get().prerenderMarkdown((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        }
    }

    protected Player player() {
        return Minecraft.getInstance().player;
    }

    protected BookCategory getSavedOrAddressedCategory(Book book, BookAddress address) {
        if (address.categoryId() != null) {
            return book.getCategory(address.categoryId());
        }
        if (address.ignoreSavedCategory()) {
            return null;
        }
        BookVisualState state = BookVisualStateManager.get().getBookStateFor(this.player(), book);
        if (state != null && state.openCategory != null) {
            return book.getCategory(state.openCategory);
        }
        return null;
    }

    protected BookCategory getSavedOrAddressedCategoryOrDefault(Book book, BookAddress address) {
        BookCategory savedCategory = this.getSavedOrAddressedCategory(book, address);
        if (savedCategory == null) {
            List<BookCategory> categories = book.getCategoriesSorted();
            if (categories.size() == 1) {
                return categories.getFirst();
            }
            return book.getCategoriesSorted().stream().filter(BookCategory::showCategoryButton).findFirst().orElseThrow();
        }
        return savedCategory;
    }

    protected BookEntry getSavedOrAddressedEntry(BookCategory category, BookAddress address) {
        BookEntry openEntry;
        if (address.entryId() != null) {
            return category.getEntry(address.entryId());
        }
        if (address.ignoreSavedEntry()) {
            return null;
        }
        CategoryVisualState state = BookVisualStateManager.get().getCategoryStateFor(this.player(), category);
        if (state != null && state.openEntry != null && (openEntry = category.getEntry(state.openEntry)) != null && !(openEntry instanceof CategoryLinkBookEntry)) {
            return openEntry;
        }
        return null;
    }

    protected BookEntry getSavedOrAddressedEntryOrDefault(BookCategory category, BookAddress address) {
        BookEntry savedEntry = this.getSavedOrAddressedEntry(category, address);
        if (savedEntry == null && category.getEntryToOpen() != null) {
            BookEntry entryToOpen = category.getEntry(category.getEntryToOpen());
            if (!category.openEntryToOpenOnlyOnce() || !BookUnlockStateManager.get().isReadFor((Player)Minecraft.getInstance().player, entryToOpen)) {
                return entryToOpen;
            }
        }
        return savedEntry;
    }

    public void openBook(BookAddress address) {
        BookDisplayMode displayMode;
        this.safeguardBooksBuilt();
        if (this.showErrorScreen(address.bookId())) {
            return;
        }
        Book book = BookDataManager.get().getBook(address.bookId());
        if (book.isLeaflet()) {
            BookAddress bookAddress = address = address.page() > -1 ? book.getLeafletAddress().withPage(address.page()) : book.getLeafletAddress();
        }
        if ((displayMode = book.getDisplayMode()) == BookDisplayMode.INDEX) {
            this.openBookInIndexMode(book, address);
        } else if (displayMode == BookDisplayMode.NODE) {
            this.openBookInNodeMode(book, address);
        }
    }

    protected void openBookInNodeMode(Book book, BookAddress address) {
        BookParentNodeScreen openBookParentScreen = new BookParentNodeScreen(book);
        this.openBookParentScreen = openBookParentScreen;
        BookVisualState state = BookVisualStateManager.get().getBookStateFor(this.player(), book);
        if (state != null) {
            openBookParentScreen.loadState(state);
        }
        Minecraft.getInstance().setScreen((Screen)openBookParentScreen);
        openBookParentScreen.onDisplay();
        BookCategory openCategory = this.getSavedOrAddressedCategoryOrDefault(book, address);
        this.openCategory(openCategory, address);
    }

    protected void openBookInIndexMode(Book book, BookAddress address) {
        BookParentIndexScreen openBookParentScreen = new BookParentIndexScreen(book);
        this.openBookParentScreen = openBookParentScreen;
        BookVisualState state = BookVisualStateManager.get().getBookStateFor(this.player(), book);
        if (state != null) {
            openBookParentScreen.loadState(state);
        }
        Minecraft.getInstance().setScreen((Screen)openBookParentScreen);
        openBookParentScreen.onDisplay();
        BookCategory openCategory = this.getSavedOrAddressedCategory(book, address);
        if (openCategory == null) {
            return;
        }
        this.openCategory(openCategory, address);
    }

    @ApiStatus.Internal
    public void openCategory(BookCategory category, BookAddress address) {
        BookDisplayMode displayMode;
        if (this.openBookCategoryScreen != null) {
            BookGuiManager.get().closeCategoryScreen(this.openBookCategoryScreen);
        }
        if ((displayMode = category.getDisplayMode()) == BookDisplayMode.INDEX || category.getBook().getDisplayMode() == BookDisplayMode.INDEX) {
            this.openCategoryInIndexMode(category, address);
        } else if (displayMode == BookDisplayMode.NODE) {
            this.openCategoryInNodeMode(category, address);
        }
        BookVisualState bookState = BookVisualStateManager.get().getBookStateFor(this.player(), this.openBookParentScreen.getBook());
        bookState.openCategory = null;
    }

    protected void openCategoryInNodeMode(BookCategory category, BookAddress address) {
        BookParentScreen bookParentScreen;
        if (category.getBook().getDisplayMode() != BookDisplayMode.NODE || !((bookParentScreen = this.openBookParentScreen) instanceof BookParentNodeScreen)) {
            throw new IllegalStateException("Cannot open category in node mode if book is not in node mode.");
        }
        BookParentNodeScreen bookParentNodeScreen = (BookParentNodeScreen)bookParentScreen;
        BookCategoryNodeScreen openBookCategoryScreen = new BookCategoryNodeScreen(bookParentNodeScreen, category);
        this.openBookCategoryScreen = openBookCategoryScreen;
        CategoryVisualState state = BookVisualStateManager.get().getCategoryStateFor(this.player(), category);
        if (state != null) {
            openBookCategoryScreen.loadState(state);
        }
        bookParentNodeScreen.setCurrentCategoryScreen(openBookCategoryScreen);
        openBookCategoryScreen.onDisplay();
        BookEntry openEntry = this.getSavedOrAddressedEntryOrDefault(category, address);
        if (openEntry == null) {
            return;
        }
        this.openEntry(openEntry, address);
    }

    protected void openCategoryInIndexMode(BookCategory category, BookAddress address) {
        BookParentScreen bookParentScreen;
        BookCategoryIndexScreen openBookCategoryScreen = new BookCategoryIndexScreen(this.openBookParentScreen, category);
        if (category.getBook().getDisplayMode() == BookDisplayMode.NODE && (bookParentScreen = this.openBookParentScreen) instanceof BookParentNodeScreen) {
            BookParentNodeScreen bookParentNodeScreen = (BookParentNodeScreen)bookParentScreen;
            bookParentNodeScreen.setCurrentCategoryScreen(new DummyBookCategoryNodeScreen(bookParentNodeScreen, category));
            openBookCategoryScreen = new BookCategoryIndexOnNodeScreen(bookParentNodeScreen, category);
        }
        this.openBookCategoryScreen = openBookCategoryScreen;
        CategoryVisualState state = BookVisualStateManager.get().getCategoryStateFor(this.player(), category);
        if (state != null) {
            openBookCategoryScreen.loadState(state);
        }
        ClientServices.GUI.pushGuiLayer(openBookCategoryScreen);
        openBookCategoryScreen.onDisplay();
        BookEntry openEntry = this.getSavedOrAddressedEntryOrDefault(category, address);
        if (openEntry == null) {
            return;
        }
        this.openEntry(openEntry, address);
    }

    @ApiStatus.Internal
    public void openContentEntry(BookContentEntry entry, BookAddress address) {
        BookEntryScreen openBookEntryScreen;
        this.openBookEntryScreen = openBookEntryScreen = entry.getBook().getPageDisplayMode() == PageDisplayMode.DOUBLE_PAGE ? new BookEntryDoublePageScreen(this.openBookParentScreen, entry) : new BookEntrySinglePageScreen(this.openBookParentScreen, entry);
        if (address.page() != -1) {
            openBookEntryScreen.goToPage(address.page(), false);
        } else {
            EntryVisualState state = BookVisualStateManager.get().getEntryStateFor(this.player(), entry);
            if (state != null) {
                openBookEntryScreen.loadState(state);
                if (address.ignoreSavedPage()) {
                    openBookEntryScreen.setOpenPagesIndex(0);
                }
            }
        }
        ClientServices.GUI.pushGuiLayer(openBookEntryScreen);
        CategoryVisualState categoryState = BookVisualStateManager.get().getCategoryStateFor(this.player(), this.openBookCategoryScreen.getCategory());
        categoryState.openEntry = null;
    }

    @ApiStatus.Internal
    public void openCategoryLinkEntry(CategoryLinkBookEntry entry) {
        BookCategory category = entry.getCategoryToOpen();
        this.openBook(BookAddress.defaultFor(category));
    }

    @ApiStatus.Internal
    public void openEntry(BookEntry entry, BookAddress address) {
        if (!BookUnlockStateManager.get().isReadFor(this.player(), entry)) {
            Services.NETWORK.sendToServer(new BookEntryReadMessage(entry.getBook().getId(), entry.getId()));
            ModonomiconEvents.client().entryFirstRead(new EntryFirstReadEvent(entry.getBook().getId(), entry.getId()));
        }
        entry.openEntry(address);
    }

    public void pushHistory(ResourceLocation bookId, @Nullable ResourceLocation entryId, int page) {
        Book book = BookDataManager.get().getBook(bookId);
        BookEntry entry = book.getEntry(entryId);
        this.history.computeIfAbsent(bookId, k -> new Stack()).push(BookAddress.of(bookId, entry.getCategoryId(), entryId, page));
    }

    public void pushHistory(ResourceLocation bookId, @Nullable ResourceLocation categoryId, @Nullable ResourceLocation entryId, int page) {
        this.history.computeIfAbsent(bookId, k -> new Stack()).push(BookAddress.of(bookId, categoryId, entryId, page));
    }

    public void pushHistory(BookAddress entry) {
        this.history.computeIfAbsent(entry.bookId(), k -> new Stack()).push(entry);
    }

    public BookAddress popHistory(ResourceLocation bookId) {
        if (!this.history.containsKey(bookId) || this.history.get(bookId).isEmpty()) {
            return null;
        }
        return this.history.get(bookId).pop();
    }

    public BookAddress peekHistory(ResourceLocation bookId) {
        if (!this.history.containsKey(bookId) || this.history.get(bookId).isEmpty()) {
            return null;
        }
        return this.history.get(bookId).peek();
    }

    public int getHistorySize(ResourceLocation bookId) {
        if (!this.history.containsKey(bookId)) {
            return 0;
        }
        return this.history.get(bookId).size();
    }

    public void resetHistory() {
        this.history.clear();
    }

    public void openEntry(ResourceLocation bookId, ResourceLocation entryId, int page) {
        Book book = BookDataManager.get().getBook(bookId);
        BookEntry entry = book.getEntry(entryId);
        this.openEntry(bookId, entry.getCategoryId(), entryId, page);
    }

    public void keepMousePosition(Runnable run) {
        Pair mousePos = Pair.of((Object)Minecraft.getInstance().mouseHandler.xpos(), (Object)Minecraft.getInstance().mouseHandler.ypos());
        run.run();
        InputConstants.grabOrReleaseMouse((Window)Minecraft.getInstance().getWindow(), (int)212993, (double)((Double)mousePos.getFirst()), (double)((Double)mousePos.getSecond()));
    }

    public void openEntry(ResourceLocation bookId, @Nullable ResourceLocation categoryId, @Nullable ResourceLocation entryId, int page) {
        this.safeguardBooksBuilt();
        if (bookId == null) {
            throw new IllegalArgumentException("bookId cannot be null");
        }
        if (this.showErrorScreen(bookId)) {
            // empty if block
        }
        this.keepMousePosition(() -> {
            if (this.openBookEntryScreen != null) {
                this.closeScreenStack(this.openBookEntryScreen);
            } else if (this.openBookCategoryScreen != null) {
                this.closeScreenStack(this.openBookCategoryScreen);
            } else if (this.openBookParentScreen != null) {
                this.closeScreenStack(this.openBookParentScreen);
            }
            this.openBook(BookAddress.ignoreSaved(bookId, categoryId, entryId, page));
        });
    }

    public void closeEntryScreen(BookEntryScreen screen) {
        this.closeEntryScreen(screen, false);
    }

    public void closeEntryScreen(BookEntryScreen screen, boolean overrideStoreLastOpenPageWhenClosingEntry) {
        if (ClientServices.GUI.getCurrentScreen() == screen) {
            ClientServices.GUI.popGuiLayer();
        }
        this.openBookEntryScreen = null;
        EntryVisualState state = BookVisualStateManager.get().getEntryStateFor(this.player(), screen.getEntry());
        screen.saveState(state, overrideStoreLastOpenPageWhenClosingEntry || ClientServices.CLIENT_CONFIG.storeLastOpenPageWhenClosingEntry());
        Services.NETWORK.sendToServer(new SaveEntryStateMessage((BookEntry)screen.getEntry(), state));
        if (screen.getBook().isLeaflet()) {
            this.closeScreenStack(this.openBookCategoryScreen);
        }
    }

    public void closeCategoryScreen(BookCategoryScreen screen) {
        if (ClientServices.GUI.getCurrentScreen() == screen) {
            ClientServices.GUI.popGuiLayer();
        }
        this.openBookCategoryScreen = null;
        CategoryVisualState state = BookVisualStateManager.get().getCategoryStateFor(this.player(), screen.getCategory());
        screen.saveState(state);
        Services.NETWORK.sendToServer(new SaveCategoryStateMessage(screen.getCategory(), state));
    }

    public void closeParentScreen(BookParentScreen screen) {
        ClientServices.GUI.popGuiLayer();
        Minecraft.getInstance().setScreen(null);
        this.openBookParentScreen = null;
        BookVisualState state = BookVisualStateManager.get().getBookStateFor(this.player(), screen.getBook());
        screen.saveState(state);
        Services.NETWORK.sendToServer(new SaveBookStateMessage(screen.getBook(), state));
        this.sendBookClosedMessage(screen);
    }

    protected void sendBookClosedMessage(BookParentScreen screen) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Book bookInMainhand = ModonomiconItem.getBook(player.getMainHandItem());
            if (bookInMainhand != null && screen.getBook().getId().equals((Object)bookInMainhand.getId())) {
                Services.NETWORK.sendToServer(new BookClosedMessage(InteractionHand.MAIN_HAND));
            } else {
                Services.NETWORK.sendToServer(new BookClosedMessage(InteractionHand.OFF_HAND));
            }
        }
    }

    public void closeScreenStack(BookParentScreen screen) {
        this.closeParentScreen(screen);
    }

    public void closeScreenStack(BookCategoryScreen screen) {
        this.closeCategoryScreen(screen);
        if (this.openBookParentScreen == null) {
            return;
        }
        BookVisualState bookState = BookVisualStateManager.get().getBookStateFor(this.player(), screen.getCategory().getBook());
        bookState.openCategory = screen.getCategory().getId();
        this.closeScreenStack(this.openBookParentScreen);
    }

    public void closeScreenStack(BookEntryScreen screen) {
        this.closeEntryScreen(screen, true);
        if (this.openBookCategoryScreen == null) {
            return;
        }
        CategoryVisualState categoryState = BookVisualStateManager.get().getCategoryStateFor(this.player(), this.openBookCategoryScreen.getCategory());
        categoryState.openEntry = screen.getEntry().getId();
        this.closeScreenStack(this.openBookCategoryScreen);
    }
}

