/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ARGB;

public class BookContentRenderer {
    private static long lastTurnPageSoundTime;

    public static void drawFromContentTexture(RenderPipeline renderPipeline, GuiGraphics guiGraphics, Book book, int x, int y, int u, int v, int w, int h, int color) {
        guiGraphics.blit(renderPipeline, book.getBookContentTexture(), x, y, (float)u, (float)v, w, h, 512, 256, color);
    }

    public static void drawFromContentTexture(RenderPipeline renderPipeline, GuiGraphics guiGraphics, Book book, int x, int y, int u, int v, int w, int h) {
        guiGraphics.blit(renderPipeline, book.getBookContentTexture(), x, y, (float)u, (float)v, w, h, 512, 256);
    }

    public static void drawTitleSeparator(GuiGraphics guiGraphics, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x - w / 2;
        int color = ARGB.colorFromFloat((float)0.8f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, book, rx, y, 0, 253, w, h, color);
    }

    public static void drawLock(GuiGraphics guiGraphics, Book book, int x, int y) {
        BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, book, x, y, 496, 0, 16, 16);
    }

    public static void drawLock(GuiGraphics guiGraphics, Book book, int x, int y, int color) {
        BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, book, x, y, 496, 0, 16, 16, color);
    }

    public static void playTurnPageSound(Book book) {
        if (ClientTicks.ticks - lastTurnPageSoundTime > 6L) {
            SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(book.getTurnPageSound());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)((float)(0.7 + Math.random() * 0.3))));
            lastTurnPageSoundTime = ClientTicks.ticks;
        }
    }

    public static void renderBookBackground(GuiGraphics guiGraphics, ResourceLocation bookContentTexture) {
        int x = 0;
        int y = 0;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, bookContentTexture, x, y, 0.0f, 0.0f, 272, 178, 512, 256);
    }
}

