/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class BookButton
extends Button {
    protected final BookScreenWithButtons parent;
    protected final int u;
    protected final int v;
    protected final Supplier<Boolean> displayCondition;
    protected final List<Component> tooltip;

    public BookButton(BookScreenWithButtons parent, int x, int y, int u, int v, int w, int h, Component pMessage, Button.OnPress onPress, Component ... tooltip) {
        this(parent, x, y, u, v, w, h, () -> true, pMessage, onPress, tooltip);
    }

    public BookButton(BookScreenWithButtons parent, int x, int y, int u, int v, int w, int h, Supplier<Boolean> displayCondition, Component pMessage, Button.OnPress onPress, Component ... tooltip) {
        super(x, y, w, h, pMessage, onPress, Button.DEFAULT_NARRATION);
        this.parent = parent;
        this.u = u;
        this.v = v;
        this.displayCondition = displayCondition;
        this.tooltip = List.of(tooltip);
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.active = this.visible = this.displayCondition.get().booleanValue();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, this.parent.getBook(), this.getX(), this.getY(), this.u + (this.isHovered() ? this.width : 0), this.v, this.width, this.height);
        if (this.isHovered()) {
            this.parent.setTooltip(this.tooltip);
        }
    }
}

