/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.node.BookParentNodeScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class CategoryButton
extends Button {
    private final BookParentNodeScreen parent;
    private final BookCategory category;

    public CategoryButton(BookParentNodeScreen parent, BookCategory category, int pX, int pY, int width, int height, Button.OnPress pOnPress, Tooltip tooltip) {
        super(pX, pY, width, height, (Component)Component.literal((String)""), pOnPress, Button.DEFAULT_NARRATION);
        this.setTooltip(tooltip);
        this.parent = parent;
        this.category = category;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.visible) {
            int color;
            guiGraphics.pose().pushMatrix();
            int xOffset = this.getCategory().getBook().getCategoryButtonXOffset();
            guiGraphics.pose().translate((float)xOffset, 0.0f);
            boolean texX = false;
            int texY = 145;
            int renderX = this.getX();
            int renderWidth = this.width;
            if (BookGuiManager.get().openBookCategoryScreen != null && this.category == BookGuiManager.get().openBookCategoryScreen.getCategory()) {
                renderX -= 3;
                renderWidth += 3;
                color = ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (this.isHovered()) {
                --renderX;
                ++renderWidth;
                color = ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                color = ARGB.colorFromFloat((float)1.0f, (float)0.8f, (float)0.8f, (float)0.8f);
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.parent.getBookOverviewTexture(), renderX, this.getY(), (float)texX, (float)texY, renderWidth, this.height, 256, 256, color);
            int iconSize = 16;
            int centerIconOffset = iconSize / 2;
            float scale = this.getCategory().getBook().getCategoryButtonIconScale();
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(renderX + 8), (float)(this.getY() + 2));
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)centerIconOffset, (float)centerIconOffset);
            guiGraphics.pose().scale(scale, scale);
            guiGraphics.pose().translate((float)(-centerIconOffset), (float)(-centerIconOffset));
            this.category.getIcon().render(guiGraphics, 0, 0);
            guiGraphics.pose().popMatrix();
            guiGraphics.pose().popMatrix();
            guiGraphics.pose().popMatrix();
        }
    }
}

