/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.LinkHandler;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class PatchouliLinkHandler
extends LinkHandler {
    public PatchouliLinkHandler(BookEntryScreen screen) {
        super(screen);
    }

    @Override
    public LinkHandler.ClickResult handleClick(@NotNull Style pStyle) {
        ClickEvent event = pStyle.getClickEvent();
        if (event == null) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (event.action() != ClickEvent.Action.OPEN_FILE || !(event instanceof ClickEvent.OpenFile)) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        ClickEvent.OpenFile openFile = (ClickEvent.OpenFile)event;
        if (!PatchouliLink.isPatchouliLink(openFile.path())) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        PatchouliLink link = PatchouliLink.from(openFile.path());
        if (link.bookId == null) {
            return LinkHandler.ClickResult.FAILURE;
        }
        BookGuiManager.get().keepMousePosition(() -> {
            BookGuiManager.get().closeScreenStack(this.screen());
            Services.PATCHOULI.openEntry(link.bookId, link.entryId, link.pageNumber);
        });
        return LinkHandler.ClickResult.SUCCESS;
    }
}

