/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.index;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.bookmarks.BookBookmarksScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryListButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ReadAllButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ShowBookmarksButton;
import com.klikli_dev.modonomicon.client.gui.book.search.BookSearchScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;

public class BookParentIndexScreen
extends BookPaginatedScreen
implements BookParentScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<Button> entryButtons = new ArrayList<Button>();
    protected final Book book;
    private final List<BookCategory> visibleEntries = new ArrayList<BookCategory>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookCategory> allEntries;
    private List<Component> tooltip;
    private boolean hasUnreadEntries;
    private boolean hasUnreadUnlockedEntries;

    public BookParentIndexScreen(Book book) {
        super((Component)Component.translatable((String)book.getName()));
        this.book = book;
    }

    protected void updateUnreadEntriesState() {
        this.hasUnreadEntries = this.book.getEntries().values().stream().anyMatch(e -> !BookUnlockStateManager.get().isReadFor((Player)this.minecraft.player, (BookEntry)e));
        this.hasUnreadUnlockedEntries = this.book.getEntries().values().stream().anyMatch(e -> BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, (BookEntry)e) && !BookUnlockStateManager.get().isReadFor((Player)this.minecraft.player, (BookEntry)e));
    }

    public void handleButtonEntry(Button button) {
        if (button instanceof CategoryListButton) {
            CategoryListButton categoryListButton = (CategoryListButton)button;
            BookGuiManager.get().openCategory(categoryListButton.getCategory(), BookAddress.defaultFor(categoryListButton.getCategory()));
        }
    }

    protected void drawTitle(GuiGraphics guiGraphics, int x, int y) {
        float scale = Math.min(1.0f, 120.0f / (float)this.font.width((FormattedText)this.getTitle()));
        if (scale < 1.0f) {
            guiGraphics.pose().translate((float)x - (float)x * scale, (float)y - (float)y * scale);
            guiGraphics.pose().scale(scale, scale);
        }
        this.drawCenteredStringNoShadow(guiGraphics, this.getTitle(), x, y, this.getBook().getDefaultTitleColor(), 1.0f);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width((FormattedText)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.getBook());
            }
        }
    }

    protected void drawTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.setTooltipForNextFrame(this.tooltip.stream().map(Component::getVisualOrderText).toList(), pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    protected boolean shouldShowDescription() {
        return !this.book.getDescription().isEmpty();
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.renderables.remove(b);
            this.children().remove(b);
            this.narratables.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        this.visibleEntries.addAll(this.allEntries);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            if (this.shouldShowDescription()) {
                this.addEntryButtons(138, 35, 0, 11);
            } else {
                this.addEntryButtons(12, 35, 0, 11);
                this.addEntryButtons(138, 15, 11, 13);
            }
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    private Collection<BookCategory> getEntries() {
        return this.getBook().getCategories().values();
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.book;
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (BookGuiManager.get().openBookCategoryScreen != null) {
            return;
        }
        this.resetTooltip();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop);
        BookContentRenderer.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            if (!this.shouldShowDescription()) {
                this.drawTitle(guiGraphics, 74, 15);
                BookContentRenderer.drawTitleSeparator(guiGraphics, this.getBook(), 74, 27);
            } else {
                this.drawTitle(guiGraphics, 74, 15);
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.category.index_list_title"), 203, 15, this.getBook().getDefaultTitleColor());
                BookContentRenderer.drawTitleSeparator(guiGraphics, this.getBook(), 74, 27);
                BookContentRenderer.drawTitleSeparator(guiGraphics, this.getBook(), 203, 27);
                BookPageRenderer.renderBookTextHolder(guiGraphics, this.book.getDescription(), this.font, 12, 37, 124, 118);
            }
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    @Override
    public void onDisplay() {
        this.updateUnreadEntriesState();
    }

    @Override
    public void onClose() {
        BookGuiManager.get().closeParentScreen(this);
    }

    @Override
    public void loadState(BookVisualState state) {
        this.openPagesIndex = state.openPagesIndex;
    }

    @Override
    public void saveState(BookVisualState state) {
        state.openPagesIndex = this.openPagesIndex;
    }

    @Override
    public void onSyncBookUnlockStatesMessage(SyncBookUnlockStatesMessage message) {
        this.rebuildWidgets();
        this.updateUnreadEntriesState();
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 256) {
            BookGuiManager.get().closeScreenStack(this);
            return true;
        }
        if (event.key() == 257 && this.visibleEntries.size() == 1) {
            BookCategory entry = this.visibleEntries.get(0);
            BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
            return true;
        }
        return super.keyPressed(event);
    }

    protected boolean canSeeReadAllButton() {
        return this.hasUnreadEntries || this.hasUnreadUnlockedEntries;
    }

    protected void onReadAllButtonClick(ReadAllButton button) {
        if (this.hasUnreadUnlockedEntries && !this.minecraft.hasShiftDown()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), false));
            this.hasUnreadUnlockedEntries = false;
        } else if (this.hasUnreadEntries && this.minecraft.hasShiftDown()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), true));
            this.hasUnreadEntries = false;
        }
    }

    @Override
    public void init() {
        super.init();
        this.allEntries = this.getEntries().stream().filter(e -> BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, (BookCategory)e) && BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, (BookCategory)e)).sorted(Comparator.comparingInt(BookCategory::getSortNumber).thenComparing(a -> I18n.get((String)a.getName(), (Object[])new Object[0]))).toList();
        this.createEntryList();
        int readAllButtonX = this.bookLeft + 272 - 8;
        int readAllButtonY = this.bookTop + 14 + 15;
        ReadAllButton readAllButton = new ReadAllButton(this, readAllButtonX, readAllButtonY, () -> this.hasUnreadUnlockedEntries, this::canSeeReadAllButton, b -> this.onReadAllButtonClick((ReadAllButton)b));
        this.addRenderableWidget((GuiEventListener)readAllButton);
        int buttonHeight = 20;
        int searchButtonX = this.bookLeft + 272 - 5;
        int searchButtonY = this.bookTop + 180 - 30;
        int searchButtonWidth = 34;
        int scissorX = this.bookLeft + 272;
        SearchButton searchButton = new SearchButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onSearchButtonClick((SearchButton)b), Tooltip.create((Component)Component.translatable((String)"modonomicon.gui.open_search")));
        this.addRenderableWidget((GuiEventListener)searchButton);
        ShowBookmarksButton showBookmarksButton = new ShowBookmarksButton(this, searchButtonX, searchButtonY -= buttonHeight + 2, scissorX, searchButtonWidth, buttonHeight, b -> this.onShowBookmarksButtonClick((ShowBookmarksButton)b), Tooltip.create((Component)Component.translatable((String)"modonomicon.gui.open_bookmarks")));
        this.addRenderableWidget((GuiEventListener)showBookmarksButton);
    }

    protected void onSearchButtonClick(SearchButton button) {
        ClientServices.GUI.pushGuiLayer(new BookSearchScreen(this));
    }

    protected void onShowBookmarksButtonClick(ShowBookmarksButton button) {
        ClientServices.GUI.pushGuiLayer(new BookBookmarksScreen(this));
    }

    protected void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            CategoryListButton button = new CategoryListButton(this.visibleEntries.get(start + i), this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.addRenderableWidget((GuiEventListener)button);
            this.entryButtons.add(button);
        }
    }

    @Override
    protected boolean isClickOutsideEntry(double pMouseX, double pMouseY) {
        return pMouseX < (double)(this.bookLeft - 20) || pMouseX > (double)(this.bookLeft + 272 + 20 + 20) || pMouseY < (double)(this.bookTop - 20) || pMouseY > (double)(this.bookTop + 180 + 20);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

