/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.util.EntityUtil;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BookEntityPageRenderer
extends BookPageRenderer<BookEntityPage>
implements PageWithTextRenderer {
    private Entity entity;
    private boolean errored;
    private float renderScale;
    private float renderOffset;

    public BookEntityPageRenderer(BookEntityPage page) {
        super(page);
    }

    private void renderEntity(GuiGraphics guiGraphics, int left, int top, float rotation) {
        Entity entity = this.entity;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        EntityRenderDispatcher erd = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = erd.getRenderer((Entity)livingEntity);
        EntityRenderState entityrenderstate = entityrenderer.createRenderState((Entity)livingEntity, 10.0f);
        entityrenderstate.lightCoords = 0xF000F0;
        entityrenderstate.hitboxesRenderState = null;
        entityrenderstate.shadowPieces.clear();
        entityrenderstate.outlineColor = 0;
        int boxX = left + 62 + 53;
        int boxY = top + 7;
        int boxX2 = boxX + 106;
        int boxY2 = boxY + 106;
        float scale = this.renderScale;
        float entityHeight = this.entity.getBbHeight();
        float yOffset = this.renderOffset;
        Vector3f translation = new Vector3f(0.0f, entityHeight / 2.0f + yOffset, 0.0f);
        Quaternionf rotationQuat = new Quaternionf().rotateZ((float)Math.PI);
        rotationQuat.mul((Quaternionfc)new Quaternionf().rotateY(rotation * (float)Math.PI / 180.0f));
        guiGraphics.submitEntityRenderState(entityrenderstate, scale, translation, rotationQuat, null, boxX, boxY, boxX2, boxY2);
    }

    private void loadEntity(Level world) {
        if (!(this.errored || this.entity != null && this.entity.isAlive())) {
            try {
                Function<Level, Entity> entityLoader = EntityUtil.getEntityLoader(((BookEntityPage)this.page).getEntityId());
                this.entity = entityLoader.apply(world);
                float width = this.entity.getBbWidth();
                float height = this.entity.getBbHeight();
                float entitySize = Math.max(1.0f, Math.max(width, height));
                this.renderScale = 100.0f / entitySize * 0.75f * ((BookEntityPage)this.getPage()).getScale();
                this.renderOffset = Math.max(height, entitySize) * 0.5f + ((BookEntityPage)this.getPage()).getOffset();
            }
            catch (Exception e) {
                this.errored = true;
                Modonomicon.LOG.error("Failed to load entity", (Throwable)e);
            }
        }
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.loadEntity((Level)Minecraft.getInstance().level);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        Style style;
        if (!((BookEntityPage)this.page).getEntityName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookEntityPage)this.page).getEntityName(), false, 62, 0);
        }
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookEntityPage)this.getPage()).getText(), 0, textY, 124, 155 - textY);
        int x = 9;
        int y = 7;
        BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, ((BookEntityPage)this.getPage()).getBook(), x, y, 405, 149, 106, 106);
        if (this.errored) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"modonomicon.gui.page.entity.loading_error"), 58, 60, 0xFF0000, true);
        }
        if (this.entity != null) {
            float rotation = ((BookEntityPage)this.page).doesRotate() ? ClientTicks.total : ((BookEntityPage)this.page).getDefaultRotation();
            this.renderEntity(guiGraphics, this.left, this.top, rotation);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (!((BookEntityPage)this.page).getEntityName().isEmpty() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookEntityPage)this.page).getEntityName(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookEntityPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 115;
    }
}

