/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.pip;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.state.pip.GuiMultiblockRenderState;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class GuiMultiblockRenderer
extends PictureInPictureRenderer<GuiMultiblockRenderState> {
    public GuiMultiblockRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    public Class<GuiMultiblockRenderState> getRenderStateClass() {
        return GuiMultiblockRenderState.class;
    }

    protected void renderToTexture(GuiMultiblockRenderState state, PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        state.multiblock().setLevel((Level)level);
        Vec3i size = state.size();
        int sizeX = size.getX();
        int sizeY = size.getY();
        int sizeZ = size.getZ();
        poseStack.translate((float)sizeX / 2.0f, (float)sizeY / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        rotMat.rotate((Quaternionfc)Axis.ZP.rotationDegrees(-180.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-30.0f));
        rotMat.rotate((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = state.rotationTime();
        poseStack.translate(-offX, 0.0f, -offZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(time));
        rotMat.rotate((Quaternionfc)Axis.YP.rotationDegrees(-time));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
        rotMat.rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        poseStack.translate(offX, 0.0f, offZ);
        rotMat.transform(eye);
        eye.div(eye.w);
        Vec3 eye3 = new Vec3((double)eye.x(), (double)eye.y(), (double)eye.z());
        MultiBufferSource.BufferSource buffers = this.bufferSource;
        BlockPos checkPos = null;
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)hitResult;
            checkPos = blockRes.getBlockPos().relative(blockRes.getDirection());
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -1.0f);
        for (Multiblock.SimulateResult r : state.simulateResults()) {
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            BlockState displayedBlockState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).rotate(state.facingRotation());
            this.renderBlock(buffers, level, state.multiblock(), displayedBlockState, r.getWorldPosition(), alpha, poseStack, state.randomSource());
            Block block = displayedBlockState.getBlock();
            if (!(block instanceof EntityBlock)) continue;
            EntityBlock eb = (EntityBlock)block;
            Map<BlockPos, BlockEntity> cache = state.blockEntityCache();
            Set<BlockEntity> errored = state.erroredBlockEntities();
            BlockEntity be = cache.compute(r.getWorldPosition().immutable(), (p, cachedBe) -> {
                if (cachedBe != null && !cachedBe.getType().isValid(displayedBlockState)) {
                    return eb.newBlockEntity(p, displayedBlockState);
                }
                return cachedBe != null ? cachedBe : eb.newBlockEntity(p, displayedBlockState);
            });
            if (be == null || errored.contains(be)) continue;
            be.setLevel((Level)mc.level);
            be.setBlockState(displayedBlockState);
            poseStack.pushPose();
            BlockPos bePos = r.getWorldPosition();
            poseStack.translate((float)bePos.getX(), (float)bePos.getY(), (float)bePos.getZ());
            try {
                BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
                BlockEntityRenderer renderer = dispatcher.getRenderer(be);
                if (renderer != null) {
                    BlockEntityRenderState renderState = renderer.createRenderState();
                    renderer.extractRenderState(be, renderState, ClientTicks.partialTicks, eye3, null);
                    renderState.lightCoords = 0xF000F0;
                    FeatureRenderDispatcher featureDispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
                    CameraRenderState cameraRenderState = new CameraRenderState();
                    dispatcher.submit(renderState, poseStack, (SubmitNodeCollector)featureDispatcher.getSubmitNodeStorage(), cameraRenderState);
                    featureDispatcher.renderAllFeatures();
                }
            }
            catch (Exception e) {
                errored.add(be);
                Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderBlock(MultiBufferSource.BufferSource buffers, ClientLevel level, Multiblock multiblock, BlockState state, BlockPos pos, float alpha, PoseStack ps, RandomSource randomSource) {
        if (pos != null) {
            ps.pushPose();
            ps.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ClientServices.MULTIBLOCK.renderBlock(state, pos, multiblock, ps, (MultiBufferSource)buffers, randomSource);
            ps.popPose();
        }
    }

    protected float getTranslateY(int height, int guiScale) {
        return (float)height / 2.0f;
    }

    protected String getTextureLabel() {
        return "multiblock";
    }
}

