/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.networking.SendUnlockCodeToServerMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Base64;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class LoadUnlocksCommand
implements Command<CommandSourceStack> {
    private static final LoadUnlocksCommand CMD = new LoadUnlocksCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"load_progress").requires(cs -> cs.hasPermission(1))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String code = Minecraft.getInstance().keyboardHandler.getClipboard();
        try {
            if (code.isEmpty()) {
                throw new IllegalArgumentException("No code in clipboard.");
            }
            byte[] decoded = Base64.getDecoder().decode(code);
            if (decoded.length == 0) {
                throw new IllegalArgumentException("Decoded code is zero-length.");
            }
            Services.NETWORK.sendToServer(new SendUnlockCodeToServerMessage(code));
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"modonomicon.command.error.load_progress_client", (Object[])new Object[]{code}));
            return 0;
        }
    }
}

