/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.multiblock.matcher.TagMatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStatePropertyMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = Modonomicon.loc("blockstateproperty");
    private final BlockState displayState;
    private final Block block;
    private final Supplier<Map<String, String>> props;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected BlockStatePropertyMatcher(BlockState displayState, Block block, Supplier<Map<String, String>> props) {
        this.displayState = displayState;
        this.block = block;
        this.props = props;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.getBlock() == block && TagMatcher.checkProps(blockState, this.props);
    }

    public static BlockStatePropertyMatcher fromJson(JsonObject json, HolderLookup.Provider provider) {
        BlockState displayState = null;
        if (json.has("display")) {
            try {
                displayState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK, (StringReader)new StringReader(GsonHelper.getAsString((JsonObject)json, (String)"display")), (boolean)false).blockState();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockStatePropertyMatcher.", e);
            }
        }
        try {
            BlockStateParser.BlockResult result = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK, (StringReader)new StringReader(GsonHelper.getAsString((JsonObject)json, (String)"block")), (boolean)false);
            Map<String, String> props = BlockStatePropertyMatcher.convertProps(result.properties());
            return new BlockStatePropertyMatcher(displayState, result.blockState().getBlock(), (Supplier<Map<String, String>>)Suppliers.memoize(() -> props));
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"block\" for BlockStatePropertyMatcher.", e);
        }
    }

    public static BlockStatePropertyMatcher fromNetwork(FriendlyByteBuf buffer) {
        try {
            BlockState displayState = null;
            if (buffer.readBoolean()) {
                displayState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK, (StringReader)new StringReader(buffer.readUtf()), (boolean)false).blockState();
            }
            Block block = (Block)BuiltInRegistries.BLOCK.getValue(buffer.readResourceLocation());
            Map props = buffer.readMap(b -> b.readUtf(), b -> b.readUtf());
            return new BlockStatePropertyMatcher(displayState, block, (Supplier<Map<String, String>>)Suppliers.memoize(() -> props));
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockStatePropertyMatcher from network.", e);
        }
    }

    private static Map<String, String> convertProps(Map<Property<?>, Comparable<?>> props) {
        Object2ObjectOpenHashMap newProps = new Object2ObjectOpenHashMap();
        for (Map.Entry<Property<?>, Comparable<?>> entry : props.entrySet()) {
            BlockStatePropertyMatcher.appendProperty((Map<String, String>)newProps, entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    private static <T extends Comparable<T>> void appendProperty(Map<String, String> properties, Property<T> pProperty, Comparable<?> pValue) {
        properties.put(pProperty.getName(), pProperty.getName(pValue));
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        return this.displayState == null ? this.block.defaultBlockState() : this.displayState;
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.writeUtf(BlockStateParser.serialize((BlockState)this.displayState));
        }
        buffer.writeResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)this.block));
        buffer.writeMap(this.props.get(), (b, v) -> b.writeUtf(v), (b, v) -> b.writeUtf(v));
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.block, this.displayState, this.props);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStatePropertyMatcher that = (BlockStatePropertyMatcher)o;
        return this.block.equals(that.block) && this.props.equals(that.props) && this.displayState.equals((Object)that.displayState);
    }
}

