/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class GuiGraphicsExt {
    public static void drawTiledSprite(GuiGraphics guiGraphics, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite, int posX, int posY) {
        SpriteContents spriteContents = sprite.contents();
        GuiSpriteScaling.Tile tileScaling = new GuiSpriteScaling.Tile(spriteContents.width(), spriteContents.height());
        posY = posY + tiledHeight - scaledAmount;
        guiGraphics.enableScissor(posX, posY, posX + tiledWidth, posY + scaledAmount);
        guiGraphics.blitTiledSprite(RenderPipelines.GUI_TEXTURED, sprite, posX, posY, tiledWidth, scaledAmount, 0, 0, tileScaling.width(), tileScaling.height(), tileScaling.width(), tileScaling.height(), color);
        guiGraphics.disableScissor();
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, Component component, float x, float y, int color, boolean drawShadow) {
        int x1i = Mth.floor((float)x);
        int y1i = Mth.floor((float)y);
        float x1f = x - (float)x1i;
        float y1f = y - (float)y1i;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(x1f, y1f);
        guiGraphics.drawString(font, component, x1i, y1i, color, drawShadow);
        guiGraphics.pose().popMatrix();
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, String string, float x, float y, int color, boolean drawShadow) {
        int x1i = Mth.floor((float)x);
        int y1i = Mth.floor((float)y);
        float x1f = x - (float)x1i;
        float y1f = y - (float)y1i;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(x1f, y1f);
        guiGraphics.drawString(font, string, x1i, y1i, color, drawShadow);
        guiGraphics.pose().popMatrix();
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, FormattedCharSequence string, float x, float y, int color, boolean drawShadow) {
        int x1i = Mth.floor((float)x);
        int y1i = Mth.floor((float)y);
        float x1f = x - (float)x1i;
        float y1f = y - (float)y1i;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(x1f, y1f);
        guiGraphics.drawString(font, string, x1i, y1i, color, drawShadow);
        guiGraphics.pose().popMatrix();
    }

    public static void blitWithBorder(GuiGraphics guiGraphics, RenderPipeline pipeline, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize) {
        GuiGraphicsExt.blitWithBorder(guiGraphics, pipeline, texture, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize);
    }

    public static void blitWithBorder(GuiGraphics guiGraphics, RenderPipeline pipeline, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int maxU, int maxV, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        int fillerWidth = maxU - leftBorder - rightBorder;
        int fillerHeight = maxV - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        guiGraphics.blit(pipeline, texture, x, y, (float)u, (float)v, leftBorder, topBorder, 256, 256);
        guiGraphics.blit(pipeline, texture, x + leftBorder + canvasWidth, y, (float)(u + leftBorder + fillerWidth), (float)v, rightBorder, topBorder, 256, 256);
        guiGraphics.blit(pipeline, texture, x, y + topBorder + canvasHeight, (float)u, (float)(v + topBorder + fillerHeight), leftBorder, bottomBorder, 256, 256);
        guiGraphics.blit(pipeline, texture, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, (float)(u + leftBorder + fillerWidth), (float)(v + topBorder + fillerHeight), rightBorder, bottomBorder, 256, 256);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            guiGraphics.blit(pipeline, texture, x + leftBorder + i * fillerWidth, y, (float)(u + leftBorder), (float)v, i == xPasses ? remainderWidth : fillerWidth, topBorder, 256, 256);
            guiGraphics.blit(pipeline, texture, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, (float)(u + leftBorder), (float)(v + topBorder + fillerHeight), i == xPasses ? remainderWidth : fillerWidth, bottomBorder, 256, 256);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                guiGraphics.blit(pipeline, texture, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, (float)(u + leftBorder), (float)(v + topBorder), i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, 256, 256);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            guiGraphics.blit(pipeline, texture, x, y + topBorder + j * fillerHeight, (float)u, (float)(v + topBorder), leftBorder, j == yPasses ? remainderHeight : fillerHeight, 256, 256);
            guiGraphics.blit(pipeline, texture, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, (float)(u + leftBorder + fillerWidth), (float)(v + topBorder), rightBorder, j == yPasses ? remainderHeight : fillerHeight, 256, 256);
        }
    }
}

