/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BookIconModel {
    private final class_1799 itemStack;
    private final class_2960 texture;

    private final int width;
    private final int height;

    protected BookIconModel(class_1799 itemStack) {
        this.itemStack = itemStack;
        this.texture = null;
        this.width = ModonomiconConstants.Data.Icon.DEFAULT_WIDTH;
        this.height = ModonomiconConstants.Data.Icon.DEFAULT_HEIGHT;
    }

    protected BookIconModel(class_2960 texture, int width, int height) {
        this.texture = texture;
        this.itemStack = class_1799.field_8037;
        this.width = width;
        this.height = height;
    }

    public static BookIconModel create(class_1935 item) {
        return new BookIconModel(new class_1799(item));
    }

    public static BookIconModel create(class_1799 stack) {
        return new BookIconModel(stack);
    }

    public static BookIconModel create(class_2960 texture) {
        return create(texture, ModonomiconConstants.Data.Icon.DEFAULT_WIDTH, ModonomiconConstants.Data.Icon.DEFAULT_HEIGHT);
    }

    public static BookIconModel create(class_2960 texture, int width, int height) {
        return new BookIconModel(texture, width, height);
    }

    public JsonObject toJson() {
        if (this.texture != null) {
            JsonObject json = new JsonObject();
            json.addProperty("texture", this.texture.toString());
            json.addProperty("width", this.width);
            json.addProperty("height", this.height);
            return json;
        } else {
            JsonObject json = new JsonObject();
            json.addProperty("item", class_7923.field_41178.method_10221(this.itemStack.method_7909()).toString());
            return json;
        }
    }
}