/*
 *
 *  * SPDX-FileCopyrightText: 2022 klikli-dev
 *  *
 *  * SPDX-License-Identifier: MIT
 *
 */

package com.klikli_dev.modonomicon.api.datagen.book.condition;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class BookEntryReadConditionModel extends BookConditionModel {
    protected String entryId;

    protected BookEntryReadConditionModel(String entryId, class_2561 tooltip, String tooltipString) {
        super(Condition.ENTRY_READ, tooltip, tooltipString);
        this.entryId = entryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public JsonObject toJson() {
        var json = super.toJson();
        json.addProperty("entry_id", this.entryId);
        return json;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public static final class Builder {
        private String entryId;
        private class_2561 tooltip;
        private String tooltipString;

        private Builder() {
        }

        public static Builder aBookAdvancementConditionModel() {
            return new Builder();
        }

        public String getEntryId() {
            return this.entryId;
        }

        public class_2561 getTooltip() {
            return this.tooltip;
        }

        public String getTooltipString() {
            return this.tooltipString;
        }

        public Builder withEntry(class_2960 entryId) {
            this.entryId = entryId.toString();
            return this;
        }

        public Builder withEntry(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public Builder withTooltip(class_2561 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        /**
         * Will overwrite withTooltip
         */
        public Builder withTooltipString(String tooltipString) {
            this.tooltipString = tooltipString;
            return this;
        }


        public BookEntryReadConditionModel build() {
            BookEntryReadConditionModel model = new BookEntryReadConditionModel(this.entryId, this.tooltip, this.tooltipString);
            return model;
        }
    }
}
