/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.api.datagen.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.api.datagen.book.BookTextHolderModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookNoneConditionModel;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class BookMultiblockPageModel extends BookPageModel {
    protected BookTextHolderModel multiblockName = new BookTextHolderModel("");
    protected BookTextHolderModel text = new BookTextHolderModel("");
    protected String multiblockId;
    protected boolean showVisualizeButton = true;

    protected BookMultiblockPageModel(@NotNull String anchor, @NotNull BookConditionModel condition) {
        super(Page.MULTIBLOCK, anchor, condition);
    }

    public static Builder builder() {
        return new Builder();
    }

    public BookTextHolderModel getMultiblockName() {
        return this.multiblockName;
    }

    public String getMultiblockId() {
        return this.multiblockId;
    }

    public BookTextHolderModel getText() {
        return this.text;
    }

    public boolean showVisualizeButton() {
        return this.showVisualizeButton;
    }
    

    @Override
    public JsonObject toJson() {
        var json = super.toJson();
        json.add("multiblock_name", this.multiblockName.toJson());
        json.addProperty("multiblock_id", this.multiblockId);
        json.add("text", this.text.toJson());
        json.addProperty("show_visualize_button", this.showVisualizeButton);
        return json;
    }


    public static final class Builder {
        private String anchor = "";
        private BookConditionModel condition = new BookNoneConditionModel();
        private BookTextHolderModel multiblockName = new BookTextHolderModel("");
        private String multiblockId = "";
        private BookTextHolderModel text = new BookTextHolderModel("");
        private boolean showVisualizeButton = true;

        private Builder() {
        }

        public static Builder aBookTextPageModel() {
            return new Builder();
        }


        public Builder withAnchor(String anchor) {
            this.anchor = anchor;
            return this;
        }

        public Builder withCondition(BookConditionModel condition) {
            this.condition = condition;
            return this;
        }

        public Builder withMultiblockName(String title) {
            this.multiblockName = new BookTextHolderModel(title);
            return this;
        }

        public Builder withMultiblockName(class_2561 title) {
            this.multiblockName = new BookTextHolderModel(title);
            return this;
        }

        public Builder withMultiblockId(String multiblockId) {
            this.multiblockId = multiblockId;
            return this;
        }

        public Builder withMultiblockId(class_2960 multiblockId) {
            this.multiblockId = multiblockId.toString();
            return this;
        }

        public Builder withText(String text) {
            this.text = new BookTextHolderModel(text);
            return this;
        }

        public Builder withText(class_2561 text) {
            this.text = new BookTextHolderModel(text);
            return this;
        }

        public Builder withVisualizeButton(boolean showVisualizeButton) {
            this.showVisualizeButton = showVisualizeButton;
            return this;
        }

        public BookMultiblockPageModel build() {
            BookMultiblockPageModel bookTextPageModel = new BookMultiblockPageModel(this.anchor, this.condition);
            bookTextPageModel.multiblockId = this.multiblockId;
            bookTextPageModel.multiblockName = this.multiblockName;
            bookTextPageModel.text = this.text;
            bookTextPageModel.showVisualizeButton = this.showVisualizeButton;
            return bookTextPageModel;
        }
    }
}
