/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.bookstate.visual;

import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public class BookVisualState {
    public static final Codec<BookVisualState> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codecs.mutableMap(class_2960.field_25139, CategoryVisualState.CODEC).fieldOf("categoryStates").forGetter((state) -> state.categoryStates),
            class_2960.field_25139.optionalFieldOf("openCategory").forGetter((state) -> Optional.ofNullable(state.openCategory))).apply(instance, BookVisualState::new));

    public Map<class_2960, CategoryVisualState> categoryStates;

    public class_2960 openCategory;

    public BookVisualState() {
        this(Object2ObjectMaps.emptyMap(), Optional.empty());
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public BookVisualState(Map<class_2960, CategoryVisualState> categoryStates, Optional<class_2960> openCategory) {
        this.categoryStates = new Object2ObjectOpenHashMap<>(categoryStates);
        this.openCategory = openCategory.orElse(null);
    }
}
