/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book;

import I;
import Z;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.book.*;
import com.klikli_dev.modonomicon.book.entries.*;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.integration.ModonomiconJeiIntegration;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.networking.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.*;
import org.lwjgl.glfw.GLFW;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_2558;
import net.minecraft.class_2558.class_2559;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7923;

public class BookContentScreen extends BookPaginatedScreen {

    public static final int TOP_PADDING = 15;
    public static final int LEFT_PAGE_X = 12;
    public static final int RIGHT_PAGE_X = 141;
    public static final int PAGE_WIDTH = 124;
    public static final int PAGE_HEIGHT = 128; //TODO: Adjust to what is real

    public static final int MAX_TITLE_WIDTH = PAGE_WIDTH - 4;

    public static final int CLICK_SAFETY_MARGIN = 20;

    private static long lastTurnPageSoundTime;
    private final ContentBookEntry entry;
    private final class_2960 bookContentTexture;
    public int ticksInBook;
    public boolean simulateEscClosing;
    private List<BookPage> unlockedPages;
    private BookPage leftPage;
    private BookPage rightPage;
    private BookPageRenderer<?> leftPageRenderer;
    private BookPageRenderer<?> rightPageRenderer;
    /**
     * The index of the leftmost unlocked page being displayed.
     */
    private int openPagesIndex;
    private List<class_2561> tooltip;

    private class_1799 tooltipStack;
    private FluidHolder tooltipFluidStack;
    private boolean isHoveringItemLink;

    public BookContentScreen(BookOverviewScreen parentScreen, ContentBookEntry entry) {
        super(class_2561.method_43470(""), parentScreen);

        this.field_22787 = class_310.method_1551();

        this.entry = entry;

        this.bookContentTexture = this.parentScreen.getBook().getBookContentTexture();

        this.loadEntryState();
    }

    public static void drawFromTexture(class_332 guiGraphics, Book book, int x, int y, int u, int v, int w, int h) {
        guiGraphics.method_25290(book.getBookContentTexture(), x, y, u, v, w, h, 512, 256);
    }

    public static void drawTitleSeparator(class_332 guiGraphics, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x - w / 2;

        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(1F, 1F, 1F, 0.8F);
        //u and v are the pixel coordinates in our book_content_texture
        drawFromTexture(guiGraphics, book, rx, y, 0, 253, w, h);
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
    }

    public static void drawLock(class_332 guiGraphics, Book book, int x, int y) {
        drawFromTexture(guiGraphics, book, x, y, 496, 0, 16, 16);
    }

    public static void playTurnPageSound(Book book) {
        if (ClientTicks.ticks - lastTurnPageSoundTime > 6) {
            var sound = class_7923.field_41172.method_10223(book.getTurnPageSound());
            class_310.method_1551().method_1483().method_4873(class_1109.method_4758(sound, (float) (0.7 + Math.random() * 0.3)));
            lastTurnPageSoundTime = ClientTicks.ticks;
        }
    }

    public static void renderBookBackground(class_332 guiGraphics, class_2960 bookContentTexture) {
        int x = 0; // (this.width - BOOK_BACKGROUND_WIDTH) / 2;
        int y = 0; // (this.height - BOOK_BACKGROUND_HEIGHT) / 2;

        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        guiGraphics.method_25290(bookContentTexture, x, y, 0, 0, 272, 178, 512, 256);
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public ContentBookEntry getEntry() {
        return this.entry;
    }

    public Book getBook() {
        return this.entry.getBook();
    }

    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : (this.openPagesIndex + 2) < this.unlockedPages.size();
    }

    public void setTooltip(class_2561... strings) {
        this.setTooltip(List.of(strings));
    }

    public void setTooltip(List<class_2561> tooltip) {
        this.resetTooltip();
        this.tooltip = tooltip;
    }

    public void setTooltipStack(class_1799 stack) {
        this.resetTooltip();
        this.tooltipStack = stack;
    }

    public void setTooltipStack(FluidHolder stack) {
        this.resetTooltip();
        this.tooltipFluidStack = stack;
    }

    /**
     * Doesn't actually translate, as it's not necessary, just checks if mouse is in given area
     */
    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx; //this.getRelativeX(absMx);
        double my = absMy; //this.getRelativeY(absMy);

        return mx > x && my > y && mx <= (x + w) && my <= (y + h);
    }

    /**
     * Convert the given argument from global screen coordinates to local coordinates
     */
    public double getRelativeX(double absX) {
        return absX - this.bookLeft;
    }

    /**
     * Convert the given argument from global screen coordinates to local coordinates
     */
    public double getRelativeY(double absY) {
        return absY - this.bookTop;
    }

    public void renderItemStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1799 stack) {
        if (stack.method_7960() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }

        guiGraphics.method_51427(stack, x, y);
        guiGraphics.method_51431(this.field_22793, stack, x, y);

        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderItemStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<class_1799> stacks) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, stacks, -1);
    }

    public void renderItemStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<class_1799> stacks, int countOverride) {
        var filteredStacks = PageRendererRegistry.filterRenderableItemStacks(stacks);
        if (filteredStacks.size() > 0) {
            var currentStack = filteredStacks.get((this.ticksInBook / 20) % filteredStacks.size());
            this.renderItemStack(guiGraphics, x, y, mouseX, mouseY, countOverride > 0 ? currentStack.method_46651(countOverride) : currentStack);
        }
    }

    public void renderIngredient(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1856 ingr) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.method_8105()), -1);
    }

    public void renderIngredient(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1856 ingr, int countOverride) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.method_8105()), countOverride);
    }

    public void renderFluidStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack) {
        this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, stack, FluidHolder.BUCKET_VOLUME);
    }

    public void renderFluidStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack, int capacity) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0);
        ClientServices.FLUID.drawFluid(guiGraphics, 18, 18, stack, capacity);
        guiGraphics.method_51448().method_22909();

        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 18, 18)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderFluidStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks) {
        this.renderFluidStacks(guiGraphics, x, y, mouseX, mouseY, stacks, FluidHolder.BUCKET_VOLUME);
    }

    public void renderFluidStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks, int capacity) {
        var filteredStacks = PageRendererRegistry.filterRenderableFluidStacks(stacks);
        if (filteredStacks.size() > 0) {
            this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, filteredStacks.get((this.ticksInBook / 20) % filteredStacks.size()), capacity);
        }
    }

    private int getOpenPagesIndexForPage(int pageIndex) {
        for (var i = 0; i < this.unlockedPages.size(); i++) {
            var pageNumber = this.unlockedPages.get(i).getPageNumber();
            if (pageNumber == pageIndex) {
                return i & -2; // Rounds down to even
            }
            if (pageNumber > pageIndex) {
                // pageNumber will only increase, so we can stop here
                break;
            }
        }
        return 0;
    }

    /**
     * Will change to the specified page, if not open already
     */
    public void goToPage(int pageIndex, boolean playSound) {
        int openPagesIndex = this.getOpenPagesIndexForPage(pageIndex);
        if (openPagesIndex >= 0 && openPagesIndex < this.unlockedPages.size()) {
            if (this.openPagesIndex != openPagesIndex) {
                this.openPagesIndex = openPagesIndex;

                this.onPageChanged();
                if (playSound) {
                    playTurnPageSound(this.getBook());
                }
            }
        } else {
            Modonomicon.LOG.warn("Tried to change to page index {} corresponding with " +
                    "openPagesIndex {} but max open pages index is {}.", pageIndex, openPagesIndex, this.unlockedPages.size());
        }
    }

    public class_2583 getClickedComponentStyleAtForPage(BookPageRenderer<?> page, double pMouseX, double pMouseY) {
        if (page != null) {
            return page.getClickedComponentStyleAt(pMouseX - this.bookLeft - page.left, pMouseY - this.bookTop - page.top);
        }

        return null;
    }

    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        var leftPageClickedStyle = this.getClickedComponentStyleAtForPage(this.leftPageRenderer, pMouseX, pMouseY);
        if (leftPageClickedStyle != null) {
            return leftPageClickedStyle;
        }
		return this.getClickedComponentStyleAtForPage(this.rightPageRenderer, pMouseX, pMouseY);
    }

    public int getBookLeft() {
        return this.bookLeft;
    }

    public int getBookTop() {
        return this.bookTop;
    }

    public void removeRenderableWidgets(@NotNull Collection<? extends class_4068> renderables) {
        this.field_33816.removeIf(renderables::contains);
        this.method_25396().removeIf(c -> c instanceof class_4068 && renderables.contains(c));
        this.field_33815.removeIf(n -> n instanceof class_4068 && renderables.contains(n));
    }

    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            
            if (left) {
                this.openPagesIndex -= 2;
            } else {
                this.openPagesIndex += 2;
            }
            
            this.onPageChanged();
            if (playSound) {
                playTurnPageSound(this.getBook());
            }
        }
    }

    protected void drawTooltip(class_332 guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltipStack != null) {
            List<class_2561> tooltip = this.getTooltipFromItem(this.tooltipStack);
            guiGraphics.method_51434(class_310.method_1551().field_1772, tooltip, pMouseX, pMouseY);
        } else if (this.tooltipFluidStack != null) {
            List<class_2561> tooltip = this.getTooltipFromFluid(this.tooltipFluidStack);
            guiGraphics.method_51434(class_310.method_1551().field_1772, tooltip, pMouseX, pMouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.method_51434(class_310.method_1551().field_1772, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected boolean clickPage(BookPageRenderer<?> page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - this.bookLeft - page.left, mouseY - this.bookTop - page.top, mouseButton);
        }

        return false;
    }

    protected void renderPage(class_332 guiGraphics, BookPageRenderer<?> page, int pMouseX, int pMouseY, float pPartialTick) {
        if (page == null) {
            return;
        }

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(page.left, page.top, 0);
        page.render(guiGraphics, pMouseX - this.bookLeft - page.left, pMouseY - this.bookTop - page.top, pPartialTick);
        guiGraphics.method_51448().method_22909();
    }

    protected void beginDisplayPages() {
        //allow pages to clean up
        if (this.leftPageRenderer != null) {
            this.leftPageRenderer.onEndDisplayPage(this);
        }
        if (this.rightPageRenderer != null) {
            this.rightPageRenderer.onEndDisplayPage(this);
        }

        //get new pages
        int leftPageIndex = this.openPagesIndex;
        int rightPageIndex = leftPageIndex + 1;

        this.leftPage = leftPageIndex < this.unlockedPages.size() ? this.unlockedPages.get(leftPageIndex) : null;
        this.rightPage = rightPageIndex < this.unlockedPages.size() ? this.unlockedPages.get(rightPageIndex) : null;

        //allow pages to prepare for being displayed
        if (this.leftPage != null) {
            this.leftPageRenderer = PageRendererRegistry.getPageRenderer(this.leftPage.getType()).create(this.leftPage);
            this.leftPageRenderer.onBeginDisplayPage(this, LEFT_PAGE_X, TOP_PADDING);
        } else {
            this.leftPageRenderer = null;
        }
        if (this.rightPage != null) {
            this.rightPageRenderer = PageRendererRegistry.getPageRenderer(this.rightPage.getType()).create(this.rightPage);
            this.rightPageRenderer.onBeginDisplayPage(this, RIGHT_PAGE_X, TOP_PADDING);
        } else {
            this.rightPageRenderer = null;
        }
    }

    protected void onPageChanged() {
        this.beginDisplayPages();
    }

    protected void resetTooltip() {
        this.tooltip = null;
        this.tooltipStack = null;
        this.tooltipFluidStack = null;
    }

    private void loadEntryState() {
        var state = BookVisualStateManager.get().getEntryStateFor(this.parentScreen.getMinecraft().field_1724, this.entry);

        BookGuiManager.get().currentEntry = this.entry;
        BookGuiManager.get().currentContentScreen = this;

        if (state != null) {
            this.openPagesIndex = state.openPagesIndex;
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest(); //guard against depth test being enabled by other rendering code, that would cause ui elements to vanish

        this.resetTooltip();

        //we need to modify blit offset (now: z pose) to not draw over toasts
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0, 0, -1300);  //magic number arrived by testing until toasts show, but BookOverviewScreen does not
        this.method_25420(guiGraphics);
        guiGraphics.method_51448().method_22909();

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.bookLeft, this.bookTop, 0);
        renderBookBackground(guiGraphics, this.bookContentTexture);
        guiGraphics.method_51448().method_22909();

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.bookLeft, this.bookTop, 0);
        this.renderPage(guiGraphics, this.leftPageRenderer, pMouseX, pMouseY, pPartialTick);
        this.renderPage(guiGraphics, this.rightPageRenderer, pMouseX, pMouseY, pPartialTick);
        guiGraphics.method_51448().method_22909();

        //do not translate super (= widget rendering) -> otherwise our buttons are messed up
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);

        //do not translate tooltip, would mess up location
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    @Override
    public void method_25419() {
        if (this.simulateEscClosing || class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), GLFW.GLFW_KEY_ESCAPE)) {
            Services.NETWORK.sendToServer(new SaveEntryStateMessage(this.entry, this.openPagesIndex));

            super.method_25419();
            this.parentScreen.method_25419();

            this.simulateEscClosing = false;
        } else {
            Services.NETWORK.sendToServer(new SaveEntryStateMessage(this.entry,
                    ClientServices.CLIENT_CONFIG.storeLastOpenPageWhenClosingEntry() ? this.openPagesIndex : 0));

            this.parentScreen.getCurrentCategoryScreen().onCloseEntry(this);

            ClientServices.GUI.popGuiLayer(); //instead of super.onClose() to restore our parent screen
        }
    }

    /**
     * Make public to access from pages
     */
    @Override
    public <T extends class_364 & class_4068 & class_6379> T method_37063(T pWidget) {
        return super.method_37063(pWidget);
    }

    /**
     * Our copy of guiGraphics.renderComponentHoverEffect(); to handle book links
     */
    public void renderComponentHoverEffect(class_332 guiGraphics, @Nullable class_2583 style, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0, 0, 1000);
        var newStyle = style;
        if (style != null && style.method_10969() != null) {
            if (style.method_10969().method_10892() == class_2568.class_5247.field_24342) {
                var clickEvent = style.method_10970();
                if (clickEvent != null) {
                    if (clickEvent.method_10845() == class_2559.field_11748) {

                        //handle book links -> check if locked
                        if (BookLink.isBookLink(clickEvent.method_10844())) {
                            var link = BookLink.from(this.getBook(), clickEvent.method_10844());
                            var book = BookDataManager.get().getBook(link.bookId);
                            if (link.entryId != null) {
                                var entry = book.getEntry(link.entryId);

                                Integer page = link.pageNumber;
                                if (link.pageAnchor != null) {
                                    page = entry.getPageNumberForAnchor(link.pageAnchor);
                                }

                                //if locked, append lock warning
                                //handleComponentClicked will prevent the actual click

                                if (!BookUnlockStateManager.get().isUnlockedFor(this.field_22787.field_1724, entry)) {
                                    var oldComponent = style.method_10969().method_10891(class_2568.class_5247.field_24342);

                                    var newComponent = class_2561.method_43469(
                                            Gui.HOVER_BOOK_LINK_LOCKED,
                                            oldComponent,
                                            class_2561.method_43471(Gui.HOVER_BOOK_ENTRY_LINK_LOCKED_INFO)
                                                    .method_27694(s -> s.method_36139(0xff0015).method_10982(true))
                                                    .method_27693("\n")
                                                    .method_10852(
                                                            class_2561.method_43469(
                                                                    Gui.HOVER_BOOK_ENTRY_LINK_LOCKED_INFO_HINT,
                                                                    class_2561.method_43471(entry.getCategory().getName())
                                                                            .method_27694(s -> s.method_10977(class_124.field_1080).method_10978(true))
                                                            ).method_27694(s -> s.method_10982(false).method_10977(class_124.field_1068))
                                                    )
                                    );

                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, newComponent));
                                } else if (page != null && !BookUnlockStateManager.get().isUnlockedFor(this.field_22787.field_1724, entry.getPages().get(page))) {
                                    var oldComponent = style.method_10969().method_10891(class_2568.class_5247.field_24342);

                                    var newComponent = class_2561.method_43469(
                                            Gui.HOVER_BOOK_LINK_LOCKED,
                                            oldComponent,
                                            class_2561.method_43471(Gui.HOVER_BOOK_PAGE_LINK_LOCKED_INFO)
                                                    .method_27694(s -> s.method_36139(0xff0015).method_10982(true))
                                                    .method_27693("\n")
                                                    .method_10852(
                                                            class_2561.method_43469(
                                                                    Gui.HOVER_BOOK_PAGE_LINK_LOCKED_INFO_HINT,
                                                                    class_2561.method_43471(entry.getName())
                                                                            .method_27694(s -> s.method_10977(class_124.field_1080).method_10978(true)),
                                                                    class_2561.method_43471(entry.getCategory().getName())
                                                                            .method_27694(s -> s.method_10977(class_124.field_1080).method_10978(true))
                                                            ).method_27694(s -> s.method_10982(false).method_10977(class_124.field_1068))
                                                    )
                                    );

                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, newComponent));
                                }
                            }
                        }
                    }

                    if (clickEvent.method_10845() == class_2559.field_11750) {
                        if (CommandLink.isCommandLink(clickEvent.method_10844())) {
                            var link = CommandLink.from(this.getBook(), clickEvent.method_10844());
                            var book = BookDataManager.get().getBook(link.bookId);
                            if (link.commandId != null) {
                                var command = book.getCommand(link.commandId);

                                var oldComponent = style.method_10969().method_10891(class_2568.class_5247.field_24342);

                                if (!BookUnlockStateManager.get().canRunFor(this.field_22787.field_1724, command)) {
                                    var hoverComponent = class_2561.method_43471(Gui.HOVER_COMMAND_LINK_UNAVAILABLE).method_27692(class_124.field_1061);
                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, hoverComponent));
                                    oldComponent = hoverComponent;
                                }

                                if (method_25442()) {
                                    var newComponent = oldComponent.method_27661().method_10852(class_2561.method_43470("\n")).method_10852(
                                            class_2561.method_43470(command.getCommand()).method_27692(class_124.field_1080));
                                    newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, newComponent));
                                }
                            }
                        }
                    }
                }
            }
        }

        style = newStyle;

        //original GuiGraphics.renderComponentHoverEffect(pPoseStack, newStyle, mouseX, mouseY);
        // our own copy of the render code that limits width for the show_text action to not go out of screen
        if (style != null && style.method_10969() != null) {
            class_2568 hoverevent = style.method_10969();
            class_2568.class_5249 hoverevent$itemstackinfo = hoverevent.method_10891(class_2568.class_5247.field_24343);
            if (hoverevent$itemstackinfo != null) {
                //special handling for item link hovers -> we append another line in this.getTooltipFromItem
                if (style.method_10970() != null)// && ItemLinkRenderer.isItemLink(style.getClickEvent().getValue()))
                    this.isHoveringItemLink = true;

                //temporarily modify width to force forge to handle wrapping correctly
                var backupWidth = this.field_22789;
                this.field_22789 = this.field_22789 / 2; //not quite sure why exaclty / 2 works, but then forge wrapping handles it correctly on gui scale 3+4
                guiGraphics.method_51446(this.field_22787.field_1772, hoverevent$itemstackinfo.method_27683(), mouseX, mouseY);
                this.field_22789 = backupWidth;

                //then we reset so other item tooltip renders are not affected
                this.isHoveringItemLink = false;
            } else {
                class_2568.class_5248 hoverevent$entitytooltipinfo = hoverevent.method_10891(class_2568.class_5247.field_24344);
                if (hoverevent$entitytooltipinfo != null) {
                    if (this.field_22787.field_1690.field_1827) {
                        guiGraphics.method_51434(this.field_22787.field_1772, hoverevent$entitytooltipinfo.method_27682(), mouseX, mouseY);
                    }
                } else {
                    class_2561 component = hoverevent.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        //var width = Math.max(this.width / 2, 200); //original width calc
                        var width = (this.field_22789 / 2) - mouseX - 10; //our own
                        guiGraphics.method_51447(this.field_22787.field_1772, this.field_22787.field_1772.method_1728(component, width), mouseX, mouseY);
                    }
                }
            }

        }
        guiGraphics.method_51448().method_22909();
    }

    /**
     * Used to be override of < 1.20.0 Screen.getTooltipFromItem, which is now static
     */
    public List<class_2561> getTooltipFromItem(class_1799 pItemStack) {
        var tooltip = method_25408(class_310.method_1551(), pItemStack);

        if (this.isHoveringItemLink) {
            tooltip.add(class_2561.method_43470(""));
            if (ModonomiconJeiIntegration.isJeiLoaded()) {
                tooltip.add(class_2561.method_43471(Gui.HOVER_ITEM_LINK_INFO).method_27696(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1060)));
                tooltip.add(class_2561.method_43471(Gui.HOVER_ITEM_LINK_INFO_LINE2).method_27696(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1080)));
            } else {
                tooltip.add(class_2561.method_43471(Gui.HOVER_ITEM_LINK_INFO_NO_JEI).method_27696(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1061)));
            }
        }

        return tooltip;
    }

    public List<class_2561> getTooltipFromFluid(FluidHolder fluidStack) {
        var tooltip = ClientServices.FLUID.getTooltip(fluidStack, FluidHolder.BUCKET_VOLUME, this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070, FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY);

        if (this.isHoveringItemLink) {
            tooltip.add(class_2561.method_43470(""));
            if (ModonomiconJeiIntegration.isJeiLoaded()) {
                tooltip.add(class_2561.method_43471(Gui.HOVER_ITEM_LINK_INFO).method_27696(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1060)));
                tooltip.add(class_2561.method_43471(Gui.HOVER_ITEM_LINK_INFO_LINE2).method_27696(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1080)));
            } else {
                tooltip.add(class_2561.method_43471(Gui.HOVER_ITEM_LINK_INFO_NO_JEI).method_27696(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1061)));
            }
        }

        return tooltip;
    }


    @Override
    public boolean method_25430(@Nullable class_2583 pStyle) {

        //TODO: Refactor: this needs to be at least separate methods per action, or even some sort of handler class with a dispatcher
        if (pStyle != null) {
            var event = pStyle.method_10970();
            if (event != null) {
                if (event.method_10845() == class_2559.field_11748) {

                    //handle book links
                    if (BookLink.isBookLink(event.method_10844())) {
                        var link = BookLink.from(this.getBook(), event.method_10844());
                        var book = BookDataManager.get().getBook(link.bookId);
                        if (link.entryId != null) {
                            var entry = book.getEntry(link.entryId);

                            if (!BookUnlockStateManager.get().isUnlockedFor(this.field_22787.field_1724, entry)) {
                                //renderComponentHoverEffect will render a warning that it is locked so it is fine to exit here
                                return false;
                            }

                            Integer page = link.pageNumber;
                            if (link.pageAnchor != null) {
                                page = entry.getPageNumberForAnchor(link.pageAnchor);
                            }

                            if (page != null && !BookUnlockStateManager.get().isUnlockedFor(this.field_22787.field_1724, entry.getPages().get(page))) {
                                return false;
                            } else if (page == null) {
                                page = 0;
                            }

                            //we push the page we are currently on to the history
                            var currentPageIndex = this.unlockedPages.get(this.openPagesIndex).getPageNumber();
                            BookGuiManager.get().pushHistory(this.entry.getBook().getId(), this.entry.getCategory().getId(), this.entry.getId(), currentPageIndex);
                            BookGuiManager.get().openEntry(link.bookId, link.entryId, page);
                        } else if (link.categoryId != null) {
                            BookGuiManager.get().openEntry(link.bookId, link.categoryId, null, 0);
                            //Currently we do not push categories to history
                        } else {
                            BookGuiManager.get().openEntry(link.bookId, null, null, 0);
                            //Currently we do not push categories to history
                        }
                        return true;
                    }

                    //handle patchouli link clicks
                    if (PatchouliLink.isPatchouliLink(event.method_10844())) {
                        var link = PatchouliLink.from(event.method_10844());
                        if (link.bookId != null) {
                            //the integration class handles class loading guards if patchouli is not present
                            this.simulateEscClosing = true;
                            //this.onClose();

                            Services.PATCHOULI.openEntry(link.bookId, link.entryId, link.pageNumber);
                            return true;
                        }
                    }

                    if (ItemLinkRenderer.isItemLink(event.method_10844())) {

                        if (ModonomiconJeiIntegration.isJeiLoaded()) {
                            var itemId = event.method_10844().substring(ItemLinkRenderer.PROTOCOL_ITEM_LENGTH);
                            var itemStack = ItemStackUtil.loadFromParsed(ItemStackUtil.parseItemStackString(itemId));

                            this.method_25419(); //we have to do this before showing JEI, because super.onClose() clears Gui Layers, and thus would kill JEIs freshly spawned gui

                            if (class_437.method_25442()) {
                                ModonomiconJeiIntegration.showUses(itemStack);
                            } else {
                                ModonomiconJeiIntegration.showRecipe(itemStack);
                            }

                            if (!ModonomiconJeiIntegration.isJEIRecipesGuiOpen()) {
                                ClientServices.GUI.pushGuiLayer(this);
                            }

                            //TODO: Consider adding logic to restore content screen after JEI gui close
                            //      currently only the overview screen is restored (because JEI does not use Forges Gui Stack, only vanilla screen, thus only saves one parent screen)
                            //      we could fix that by listening to the Closing event from forge, and in that set the closing time
                            //      -> then on init of overview screen, if closing time is < delta, push last content screen from gui manager
                        }

                        return true;
                    }
                }
                if (event.method_10845() == class_2559.field_11750) {
                    //handle command link clicks
                    if (CommandLink.isCommandLink(event.method_10844())) {
                        var link = CommandLink.from(this.getBook(), event.method_10844());
                        var book = BookDataManager.get().getBook(link.bookId);
                        if (link.commandId != null) {
                            var command = book.getCommand(link.commandId);

                            if (BookUnlockStateManager.get().canRunFor(this.field_22787.field_1724, command)) {
                                Services.NETWORK.sendToServer(new ClickCommandLinkMessage(link.bookId, link.commandId));

                                //we immediately count up the usage client side -> to avoid spamming the server
                                //if the server ends up not counting up the usage, it will sync the correct info back down to us
                                //We should only do that on the client connected to a dedicated server, because on the integrated server we would count usage twice
                                //that means, for singleplayer clients OR clients that share to lan we dont call the setRunFor
                                if (this.field_22787.method_1576() == null)
                                    BookUnlockStateManager.get().setRunFor(this.field_22787.field_1724, command);
                            }

                            return true;
                        }
                    }
                }
            }
        }
        return super.method_25430(pStyle);
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        this.unlockedPages = this.entry.getUnlockedPagesFor(this.field_22787.field_1724);
        this.beginDisplayPages();

        this.method_37063(new BackButton(this, this.field_22789 / 2 - BackButton.WIDTH / 2, this.bookTop + FULL_HEIGHT - BackButton.HEIGHT / 2));
    }

    @Override
    public void method_25393() {
        super.method_25393();

        if (!method_25442()) {
            this.ticksInBook++;
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (pButton == GLFW.GLFW_MOUSE_BUTTON_LEFT) {
            var style = this.getClickedComponentStyleAt(pMouseX, pMouseY);
            if (style != null && this.method_25430(style)) {
                return true;
            }
        }

        if(super.method_25402(pMouseX, pMouseY, pButton)) {
            return true;
        }

        var clickPage = this.clickPage(this.leftPageRenderer, pMouseX, pMouseY, pButton)
                || this.clickPage(this.rightPageRenderer, pMouseX, pMouseY, pButton);

        return clickPage || super.method_25402(pMouseX, pMouseY, pButton);
    }
}
