/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class CategoryButton extends class_4185 {

    private final BookOverviewScreen parent;
    private final BookCategory category;
    private final int categoryIndex;

    public CategoryButton(BookOverviewScreen parent, BookCategory category, int categoryIndex, int pX, int pY, int width, int height, class_4241 pOnPress, class_7919 tooltip) {
        super(pX, pY, width, height, class_2561.method_43470(""), pOnPress, class_4185.field_40754);
        this.method_47400(tooltip);
        this.parent = parent;
        this.category = category;
        this.categoryIndex = categoryIndex;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    @Override
    public void method_48579(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.field_22764) {
            guiGraphics.method_51448().method_22903();
            int xOffset = this.getCategory().getBook().getCategoryButtonXOffset();
            guiGraphics.method_51448().method_46416(xOffset, 0, 0);

            int texX = 0;
            int texY = 145;

            int renderX = this.method_46426();
            int renderWidth = this.field_22758;

            if (this.categoryIndex == this.parent.getCurrentCategory()) {
                renderX -= 3;
                renderWidth += 3;
            } else if (this.method_49606()) {
                renderX -= 1;
                renderWidth += 1;
            }

            //draw category button background
            RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
            guiGraphics.method_25290(this.parent.getBookOverviewTexture(), renderX, this.method_46427(), texX, texY, renderWidth, this.field_22759, 256, 256);

            //then draw icon
            int iconSize = 16;
            int centerIconOffset = iconSize / 2;
            float scale = this.getCategory().getBook().getCategoryButtonIconScale();

            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0, 0, 100); //push category icon to front
            guiGraphics.method_51448().method_46416(renderX + 8, this.method_46427() + 2, 0); //move to desired render location

            //now scale around center
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(centerIconOffset, centerIconOffset, 0);
            guiGraphics.method_51448().method_22905(scale, scale, 1);
            guiGraphics.method_51448().method_46416(-centerIconOffset, -centerIconOffset, 0);

            this.category.getIcon().render(guiGraphics, 0, 0);

            guiGraphics.method_51448().method_22909();

            guiGraphics.method_51448().method_22909();

            guiGraphics.method_51448().method_22909();
        }
    }
}
