/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.networking.ReloadResourcesOnClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class ReloadBooksCommand implements com.mojang.brigadier.Command<class_2168> {

    private static final ReloadBooksCommand CMD = new ReloadBooksCommand();


    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {
        return class_2170.method_9247("reload")
                .requires(cs -> cs.method_9259(2))
                .executes(CMD);
    }


    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        Services.NETWORK.sendTo(context.getSource().method_44023(), new ReloadResourcesOnClientMessage());
        context.getSource().method_9226(() -> class_2561.method_43471(ModonomiconConstants.I18n.Command.RELOAD_REQUESTED), true);
        return 1;
    }
}
