/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.item;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Tooltips;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Nbt;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ModonomiconItem extends class_1792 {
    public ModonomiconItem(class_1793 pProperties) {
        super(pProperties);
    }

    public static Book getBook(class_1799 stack) {
        class_2960 res = getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookDataManager.get().getBook(res);
    }

    private static class_2960 getBookId(class_1799 stack) {
        if (!stack.method_7985() || !stack.method_7969().method_10545(Nbt.ITEM_BOOK_ID_TAG)) {
            return null;
        }

        String bookStr = stack.method_7969().method_10558(Nbt.ITEM_BOOK_ID_TAG);
        return class_2960.method_12829(bookStr);
    }

    /**
     * Sets the book state to closed in NBT. Should be called server-side.
     */
    public static void setBookClosed(class_1799 stack) {
        if (stack != null && stack.method_7985()) {
            stack.method_7969().method_10582(Nbt.ITEM_BOOK_OPEN_STATE_TAG, "closed");
        }
    }

    /**
     * Returns true if the book is open, false if closed or not set.
     */
    public static boolean isBookOpen(class_1799 stack) {
        if (stack != null && stack.method_7985() && stack.method_7969().method_10545(Nbt.ITEM_BOOK_OPEN_STATE_TAG)) {
            return "open".equals(stack.method_7969().method_10558(Nbt.ITEM_BOOK_OPEN_STATE_TAG));
        }
        return false;
    }

    public Book getBookFor(class_1799 stack) {
        return getBook(stack);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pUsedHand) {
        var itemInHand = pPlayer.method_5998(pUsedHand);

        // Set the book state to open in NBT
        if (!itemInHand.method_7985()) {
            itemInHand.method_7948();
        }
        itemInHand.method_7969().method_10582(Nbt.ITEM_BOOK_OPEN_STATE_TAG, "open");

        if (pLevel.field_9236) {
            if (itemInHand.method_7985()) {
                var book = this.getBookFor(itemInHand);
                BookGuiManager.get().openBook(book.getId());
            } else {
                Modonomicon.LOG.error("ModonomiconItem: ItemStack has no tag!");
            }
        }

        return class_1271.method_29237(itemInHand, pLevel.field_9236);
    }

    @Override
    public class_2561 method_7864(class_1799 pStack) {
        Book book = this.getBookFor(pStack);
        if (book != null) {
            return class_2561.method_43471(book.getName());
        }

        return super.method_7864(pStack);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);

        Book book = this.getBookFor(stack);
        if (book != null) {
            if (flagIn.method_8035()) {
                tooltip.add(class_2561.method_43470("Book ID: ").method_27692(class_124.field_1063)
                        .method_10852(class_2561.method_43470(book.getId().toString()).method_27692(class_124.field_1061)));
            }

            if (!book.getTooltip().isBlank()) {
                tooltip.add(class_2561.method_43471(book.getTooltip()).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add(class_2561.method_43469(Tooltips.ITEM_NO_BOOK_FOUND_FOR_STACK,
                            !stack.method_7985() ? class_2561.method_43470("{}") : class_2512.method_32270(stack.method_7969()))
                    .method_27692(class_124.field_1063));
        }
    }
}
