/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.multiblock.matcher;

import Z;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

/**
 * Matches against the predicate with the given id. Predicates are stored in {@link
 * LoaderRegistry}
 */
public class PredicateMatcher implements StateMatcher {

    public static final class_2960 TYPE = Modonomicon.loc("predicate");

    private final class_2680 displayState;
    private final class_2960 predicateId;
    private final Supplier<TriPredicate<class_1922, class_2338, class_2680>> predicate;

    private final boolean countsTowardsTotalBlocks;

    protected PredicateMatcher(class_2680 displayState, class_2960 predicateId, boolean countsTowardsTotalBlocks) {
        this.displayState = displayState;
        this.predicateId = predicateId;
        this.predicate = Suppliers.memoize(() -> LoaderRegistry.getPredicate(this.predicateId));
        this.countsTowardsTotalBlocks = countsTowardsTotalBlocks;
    }

    public static PredicateMatcher fromJson(JsonObject json) {
        try {
            var displayState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(class_3518.method_15265(json, "display")), false).comp_622();
            var predicateId = new class_2960(class_3518.method_15265(json, "predicate"));
            var countsTowardsTotalBlocks = class_3518.method_15258(json, "counts_towards_total_blocks", true);
            return new PredicateMatcher(displayState, predicateId, countsTowardsTotalBlocks);
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for PredicateMatcher.", e);
        }
    }

    public static PredicateMatcher fromNetwork(class_2540 buffer) {
        try {
            var displayState = class_2259.method_41955(class_7923.field_41175.method_46771(), new StringReader(buffer.method_19772()), false).comp_622();
            var predicateId = buffer.method_10810();
            var countsTowardsTotalBlocks = buffer.readBoolean();
            return new PredicateMatcher(displayState, predicateId, countsTowardsTotalBlocks);
        } catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse PredicateMatcher from network.", e);
        }
    }

    public class_2960 getPredicateId() {
        return this.predicateId;
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public class_2680 getDisplayedState(long ticks) {
        return this.displayState;
    }

    @Override
    public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
        return this.predicate.get();
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.method_10814(class_2259.method_9685(this.displayState));
        buffer.method_10814(this.predicateId.toString());
        buffer.writeBoolean(this.countsTowardsTotalBlocks);
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return this.countsTowardsTotalBlocks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.predicateId, this.displayState);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        var that = (PredicateMatcher) o;
        return this.predicateId.equals(that.predicateId) && this.displayState.equals(that.displayState);
    }
}
