/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.network;

import com.klikli_dev.modonomicon.networking.Message;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import java.util.function.Function;

public class ServerMessageHandler<T extends Message> implements ServerPlayNetworking.PlayChannelHandler {

    private final Function<class_2540, T> decoder;

    public ServerMessageHandler(Function<class_2540, T> decoder) {
        this.decoder = decoder;
    }

    @Override
    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        var packet = this.decoder.apply(buf);

        server.execute(() -> {
            packet.onServerReceived(server, player);
        });
    }
}
