/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ClickCommandLinkMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "click_command_link");

    public class_2960 bookId;
    public class_2960 commandId;

    public ClickCommandLinkMessage(class_2960 bookId, class_2960 commandId) {
        this.bookId = bookId;
        this.commandId = commandId;
    }

    public ClickCommandLinkMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10812(this.bookId);
        buf.method_10812(this.commandId);
    }

    @Override
    public void decode(class_2540 buf) {
        this.bookId = buf.method_10810();
        this.commandId = buf.method_10810();
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var book = BookDataManager.get().getBook(this.bookId);
        if (book != null) {
            var command = book.getCommand(this.commandId);
            if (command != null) {
                command.execute(player);
            }
        }
    }
}
