/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.google.common.collect.Lists;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_5219;
import net.minecraft.server.MinecraftServer;
import java.util.Collection;

import static com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Command.RELOAD_SUCCESS;

public class ReloadResourcesDoneMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "reload_resources_done");

    public ReloadResourcesDoneMessage() {
    }

    public ReloadResourcesDoneMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
    }

    @Override
    public void decode(class_2540 buf) {
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {

        if (!player.method_5687(2)) //same leve las the reload command
            return;

        //below is copied from ReloadCommand, modified not to need a command source and to only post messages after reload is complete
        class_3283 packrepository = minecraftServer.method_3836();
        class_5219 worlddata = minecraftServer.method_27728();
        Collection<String> selectedIds = packrepository.method_29210();
        Collection<String> packs = discoverNewPacks(packrepository, worlddata, selectedIds);
        reloadPacks(packs, player, minecraftServer);
    }

    private static Collection<String> discoverNewPacks(class_3283 pPackRepository, class_5219 pWorldData, Collection<String> pSelectedIds) {
        pPackRepository.method_14445();
        Collection<String> collection = Lists.newArrayList(pSelectedIds);
        Collection<String> collection1 = pWorldData.method_29589().comp_1010().method_29550();

        for(String s : pPackRepository.method_29206()) {
            if (!collection1.contains(s) && !collection.contains(s)) {
                collection.add(s);
            }
        }

        return collection;
    }

    public static void reloadPacks(Collection<String> pSelectedIds, class_3222 player, MinecraftServer server) {
        server.method_29439(pSelectedIds).exceptionally((error) -> {
            Modonomicon.LOG.warn("Failed to execute reload", error);
            player.method_43496(class_2561.method_43471("commands.reload.failure").method_27692(class_124.field_1061));
            return null;
        }).thenRun(() -> {
            BookUnlockStateManager.get().updateAndSyncFor(player);
            player.method_43496(class_2561.method_43471(RELOAD_SUCCESS).method_27692(class_124.field_1060));
        });
    }
}
