/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.class_161;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RequestAdvancementMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "request_advancement");

    public class_2960 advancementId;

    public RequestAdvancementMessage(class_2960 advancementId) {
        this.advancementId = advancementId;
    }

    public RequestAdvancementMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10812(this.advancementId);
    }

    @Override
    public void decode(class_2540 buf) {
        this.advancementId = buf.method_10810();
    }


    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var adv = minecraftServer.method_3851().method_12896(this.advancementId);

        if (adv != null) {
            Services.NETWORK.sendTo(player, new SendAdvancementToClientMessage(this.advancementId, adv.method_689()));
        } else {
            Modonomicon.LOG.warn("Requested Advancement {} from server, but not found", this.advancementId);
        }
    }
}
