/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.entries.*;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SaveEntryStateMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "save_entry_state");

    public BookEntry entry;
    public int openPagesIndex;

    public SaveEntryStateMessage(ContentBookEntry entry, int openPagesIndex) {
        this.entry = entry;
        this.openPagesIndex = openPagesIndex;
    }

    public SaveEntryStateMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10812(this.entry.getBook().getId());
        buf.method_10812(this.entry.getId());
        buf.method_10804(this.openPagesIndex);
    }

    @Override
    public void decode(class_2540 buf) {
        this.entry = BookDataManager.get().getBook(buf.method_10810()).getEntry(buf.method_10810());
        this.openPagesIndex = buf.method_10816();
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var currentState = BookVisualStateManager.get().getEntryStateFor(player, this.entry);
        currentState.openPagesIndex = this.openPagesIndex;
        BookVisualStateManager.get().setEntryStateFor(player, this.entry, currentState);
        BookVisualStateManager.get().syncFor(player);
    }
}
