/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Command;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SendUnlockCodeToServerMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "send_unlock_code_to_server");
    public String unlockCode;

    public SendUnlockCodeToServerMessage(String unlockCode) {
        this.unlockCode = unlockCode;
    }

    public SendUnlockCodeToServerMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10814(this.unlockCode);
    }

    @Override
    public void decode(class_2540 buf) {
        this.unlockCode = buf.method_19772();
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var book = BookUnlockStateManager.get().applyUnlockCodeFor(player, this.unlockCode);
        if (book != null) {
            player.method_43496(class_2561.method_43469(Command.SUCCESS_LOAD_PROGRESS, class_2561.method_43471(book.getName())));
        } else {
            player.method_43496(class_2561.method_43471(Command.ERROR_LOAD_PROGRESS).method_27692(class_124.field_1061));
        }

    }
}
