/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BookEntryParent {
    protected class_2960 entryId;
    protected boolean drawArrow = true;
    protected boolean lineEnabled = true;
    protected boolean lineReversed = false;

    public BookEntryParent(class_2960 entry) {
        this.entryId = entry;
    }

    public static BookEntryParent fromJson(JsonObject json) {
        var entry = new class_2960(class_3518.method_15265(json, "entry"));
        var parent = new BookEntryParent(entry);
        parent.drawArrow = class_3518.method_15258(json, "draw_arrow", parent.drawArrow);
        parent.lineEnabled = class_3518.method_15258(json, "line_enabled", parent.lineEnabled);
        parent.lineReversed = class_3518.method_15258(json, "line_reversed", parent.lineReversed);
        return parent;
    }

    public static BookEntryParent fromNetwork(class_2540 buffer) {
        var entry = buffer.method_10810();
        var parent = new BookEntryParent(entry);
        parent.drawArrow = buffer.readBoolean();
        parent.lineEnabled = buffer.readBoolean();
        parent.lineReversed = buffer.readBoolean();
        return parent;
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10812(this.entryId);
        buffer.writeBoolean(this.drawArrow);
        buffer.writeBoolean(this.lineEnabled);
        buffer.writeBoolean(this.lineReversed);
    }

    public BookEntry getEntry() {
        throw new UnsupportedOperationException("BookEntryParent is not resolved yet.");
    }

    public class_2960 getEntryId() {
        return this.entryId;
    }

    public boolean drawArrow() {
        return this.drawArrow;
    }

    public boolean isLineEnabled() {
        return this.lineEnabled;
    }

    public boolean isLineReversed() {
        return this.lineReversed;
    }
}
