/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Tooltips;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class BookEntryReadCondition extends BookCondition {

    protected class_2960 entryId;

    public BookEntryReadCondition(class_2561 tooltip, class_2960 entryId) {
        super(tooltip);
        this.entryId = entryId;
    }

    public static BookEntryReadCondition fromJson(JsonObject json) {
        var entryId = new class_2960(class_3518.method_15265(json, "entry_id"));

        var tooltip = tooltipFromJson(json);

        return new BookEntryReadCondition(tooltip, entryId);
    }

    public static BookEntryReadCondition fromNetwork(class_2540 buffer) {
        var tooltip = buffer.readBoolean() ? buffer.method_10808() : null;
        var entryId = buffer.method_10810();
        return new BookEntryReadCondition(tooltip, entryId);
    }

    @Override
    public class_2960 getType() {
        return Condition.ENTRY_READ;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.method_10805(this.tooltip);
        }
        buffer.method_10812(this.entryId);
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        var entry = context.getBook().getEntry(this.entryId);
        if (entry == null) {
            throw new IllegalArgumentException("Entry with id " + this.entryId + " not found in book " + context.getBook().getId() + "for BookEntryReadCondition. This happened while trying to unlock " + context);
        }
        return BookUnlockStateManager.get().isReadFor(player, entry);
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext entryContext) {
            this.tooltip = class_2561.method_43469(Tooltips.CONDITION_ENTRY_READ, class_2561.method_43471(entryContext.getBook().getEntry(this.entryId).getName()));
        }
        return super.getTooltip(player, context);
    }
}
