/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;

public class BookStatesSaveData extends class_18 {
    public static final Codec<BookStatesSaveData> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codecs.concurrentMap(Codecs.UUID, BookUnlockStates.CODEC).fieldOf("unlockStates").forGetter((state) -> state.unlockStates),
            Codecs.concurrentMap(Codecs.UUID, BookVisualStates.CODEC).fieldOf("visualStates").forGetter((state) -> state.visualStates)
    ).apply(instance, BookStatesSaveData::new));

    public static final String ID = "modonomicon_book_states";

    public ConcurrentMap<UUID, BookUnlockStates> unlockStates;
    public ConcurrentMap<UUID, BookVisualStates> visualStates;

    public BookStatesSaveData() {
        this(new ConcurrentHashMap<>(), new ConcurrentHashMap<>());
    }

    public BookStatesSaveData(ConcurrentMap<UUID, BookUnlockStates> unlockStates, ConcurrentMap<UUID, BookVisualStates> visualStates) {
        this.unlockStates = unlockStates;
        this.visualStates = visualStates;

        this.method_80();
    }

    public static BookStatesSaveData load(class_2487 pCompoundTag) {
        return CODEC.parse(class_2509.field_11560, pCompoundTag.method_10580("bookStates")).result().orElseThrow();
    }

    public BookUnlockStates getUnlockStates(UUID playerUUID) {
        return this.unlockStates.computeIfAbsent(playerUUID, (uuid) -> {
            this.method_80();
            return new BookUnlockStates();
        });
    }

    public BookVisualStates getVisualStates(UUID playerUUID) {
        return this.visualStates.computeIfAbsent(playerUUID, (uuid) -> {
            this.method_80();
            return new BookVisualStates();
        });
    }

    @Override
    public class_2487 method_75(class_2487 compoundTag) {
        compoundTag.method_10566("bookStates", CODEC.encodeStart(class_2509.field_11560, this).result().orElseThrow());
        return compoundTag;
    }
}
