/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.integration;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ModonomiconJeiIntegration {

    public static boolean isJeiLoaded() {
        return Services.PLATFORM.isModLoaded("jei") && ModonomiconJeiPlugin.isRuntimeAvailable();
    }

    public static boolean isJEIRecipesGuiOpen() {
        if (isJeiLoaded()) {
            return ModonomiconJeiHelper.isJEIRecipesGuiOpen();
        } else {
            Modonomicon.LOG.warn("Attempted check if JEI recipes GUI is open without JEI installed!");
        }
        return false;
    }

    public static void showRecipe(class_1799 stack) {
        if (isJeiLoaded()) {
            ModonomiconJeiHelper.showRecipe(stack);
        } else {
            Modonomicon.LOG.warn("Attempted to show JEI recipe for {} without JEI installed!", class_7923.field_41178.method_10221(stack.method_7909()));
        }
    }

    public static void showUses(class_1799 stack) {
        if (isJeiLoaded()) {
            ModonomiconJeiHelper.showUses(stack);
        } else {
            Modonomicon.LOG.warn("Attempted to show JEI usages for {} without JEI installed!", class_7923.field_41178.method_10221(stack.method_7909()));
        }
    }

    public static class ModonomiconJeiHelper {
        public static void showRecipe(class_1799 stack) {
            var focus = ModonomiconJeiPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, VanillaTypes.ITEM_STACK, stack);
            ModonomiconJeiPlugin.jeiRuntime.getRecipesGui().show(focus);
        }

        public static void showUses(class_1799 stack) {
            var focus = ModonomiconJeiPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.INPUT, VanillaTypes.ITEM_STACK, stack);
            ModonomiconJeiPlugin.jeiRuntime.getRecipesGui().show(focus);
        }

        public static boolean isJEIRecipesGuiOpen() {
            return class_310.method_1551().field_1755 instanceof IRecipesGui;
        }
    }

    @JeiPlugin
    public static class ModonomiconJeiPlugin implements IModPlugin {
        private static final class_2960 UID = new class_2960(ModonomiconAPI.ID, ModonomiconAPI.ID);

        private static IJeiRuntime jeiRuntime;

        public static boolean isRuntimeAvailable() {
            return jeiRuntime != null;
        }

        @NotNull
        @Override
        public class_2960 getPluginUid() {
            return UID;
        }

        @Override
        public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
            ModonomiconJeiPlugin.jeiRuntime = jeiRuntime;
        }

        @Override
        public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {

            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, ItemRegistry.MODONOMICON.get(), (stack, context) -> {
                if (!stack.method_7985() || !stack.method_7969().method_10545(ModonomiconConstants.Nbt.ITEM_BOOK_ID_TAG)) {
                    return "";
                }
                return stack.method_7969().method_10558(ModonomiconConstants.Nbt.ITEM_BOOK_ID_TAG);
            });
        }
    }
}
