/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.mixin;

import com.klikli_dev.modonomicon.client.BookModel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3695;
import net.minecraft.class_4724;

@Mixin(class_1092.class)
public abstract class MixinModelManager {
    @Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/resources/model/ModelBakery;getBakedTopLevelModels()Ljava/util/Map;"), method = "loadModels")
    public void replaceBookModel(class_3695 profilerFiller, Map<class_2960, class_4724.class_7774> map, class_1088 modelBakery, CallbackInfoReturnable<?> info) {
        BookModel.replace(modelBakery.method_4734(), modelBakery);
    }
}
