/*
 * SPDX-FileCopyrightText: 2025 klikli-dev
 * SPDX-License-Identifier: MIT
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import com.klikli_dev.modonomicon.item.ModonomiconItem;

public class BookClosedMessage implements Message {
    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "book_closed");

    public class_1268 hand;

    public BookClosedMessage(class_1268 hand) {
        this.hand = hand;
    }

    public BookClosedMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10817(this.hand);
    }

    @Override
    public void decode(class_2540 buf) {
        this.hand = buf.method_10818(class_1268.class);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer server, class_3222 player) {
        if (player == null) return;
        class_1799 stack = player.method_5998(this.hand);

        //Only set to closed if it is a modonomicon with a valid book.
        //The item in hand could be anything if the book screen was opened e.g. via a custom UI button.
        if (ModonomiconItem.getBook(stack) != null) {
            ModonomiconItem.setBookClosed(stack);
        }
    }
}
