/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RequestSyncBookStatesMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "request_sync_book_states");

    public RequestSyncBookStatesMessage() {
    }

    public RequestSyncBookStatesMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
    }

    @Override
    public void decode(class_2540 buf) {
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        BookUnlockStateManager.get().syncFor(player);
        BookVisualStateManager.get().syncFor(player);
    }
}
