/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SaveBookStateMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "save_book_state");

    public Book book;

    class_2960 openCategory = null;

    public SaveBookStateMessage(Book book, class_2960 openCategory) {
        this.book = book;
        this.openCategory = openCategory;
    }

    public SaveBookStateMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10812(this.book.getId());
        buf.writeBoolean(this.openCategory != null);
        if (this.openCategory != null) {
            buf.method_10812(this.openCategory);
        }
    }

    @Override
    public void decode(class_2540 buf) {
        this.book = BookDataManager.get().getBook(buf.method_10810());
        if (buf.readBoolean()) {
            this.openCategory = buf.method_10810();
        }
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var currentState = BookVisualStateManager.get().getBookStateFor(player, this.book);
        currentState.openCategory = this.openCategory;
        BookVisualStateManager.get().setBookStateFor(player, this.book, currentState);
        BookVisualStateManager.get().syncFor(player);
    }
}
