/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.*;
import com.klikli_dev.modonomicon.book.entries.*;
import com.klikli_dev.modonomicon.data.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SyncBookDataMessage implements Message {
    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "sync_book_data");
    public ConcurrentMap<class_2960, Book> books = new ConcurrentHashMap<>();

    public SyncBookDataMessage(ConcurrentMap<class_2960, Book> books) {
        this.books = books;
    }

    public SyncBookDataMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10804(this.books.size());
        for (var book : this.books.values()) {
            buf.method_10812(book.getId());
            book.toNetwork(buf);

            buf.method_10804(book.getCategories().size());
            for (var category : book.getCategories().values()) {
                buf.method_10812(category.getId());
                category.toNetwork(buf);

                buf.method_10804(category.getEntries().size());
                for (var entry : category.getEntries().values()) {
                    buf.method_10812(entry.getType());
                    entry.toNetwork(buf);
                }
            }

            buf.method_10804(book.getCommands().size());
            for (var command : book.getCommands().values()) {
                buf.method_10812(command.getId());
                command.toNetwork(buf);
            }
        }
    }

    @Override
    public void decode(class_2540 buf) {
        //build books
        int bookCount = buf.method_10816();
        for (int i = 0; i < bookCount; i++) {
            class_2960 bookId = buf.method_10810();
            Book book = Book.fromNetwork(bookId, buf);
            this.books.put(bookId, book);

            int categoryCount = buf.method_10816();
            for (int j = 0; j < categoryCount; j++) {
                class_2960 categoryId = buf.method_10810();
                BookCategory category = BookCategory.fromNetwork(categoryId, buf);

                //link category and book
                book.addCategory(category);

                int entryCount = buf.method_10816();
                for (int k = 0; k < entryCount; k++) {
                    class_2960 entryTypeId = buf.method_10810();
                    BookEntry entry = LoaderRegistry.getEntryNetworkLoader(entryTypeId).fromNetwork(buf);

                    //link entry and category
                    category.addEntry(entry);
                }
            }

            int commandCount = buf.method_10816();
            for (int j = 0; j < commandCount; j++) {
                class_2960 commandId = buf.method_10810();
                BookCommand command = BookCommand.fromNetwork(commandId, buf);

                //link command and book
                book.addCommand(command);
            }
        }
    }

    @Override
    public class_2960 getId() {
        return ID;
    }


    @Override
    public void onClientReceived(class_310 minecraft, class_1657 player) {
        BookDataManager.get().onDatapackSyncPacket(this);
    }
}
