/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SyncBookUnlockStatesMessage implements Message {

    public static final class_2960 ID = new class_2960(Modonomicon.MOD_ID, "sync_book_unlock_states");

    public BookUnlockStates states;

    public SyncBookUnlockStatesMessage(BookUnlockStates states) {
        this.states = states;
    }

    public SyncBookUnlockStatesMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_29172(class_2509.field_11560, BookUnlockStates.CODEC, this.states);
    }

    @Override
    public void decode(class_2540 buf) {
        this.states = buf.method_29171(class_2509.field_11560, BookUnlockStates.CODEC);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onClientReceived(class_310 minecraft, class_1657 player) {
        //we are not allowed to overwrite the save data if we are in singleplayer or if we are the lan host, otherwise we would overwrite the server side save data!
        if (minecraft.method_1576() == null){
            BookUnlockStateManager.get().saveData = new BookStatesSaveData(
                    new ConcurrentHashMap<>(Map.of(player.method_5667(), this.states)),
                    new ConcurrentHashMap<>()
            );
        }

        //but firing the update event is fine :)
        if (BookGuiManager.get().openOverviewScreen != null) {
            BookGuiManager.get().openOverviewScreen.onSyncBookUnlockCapabilityMessage(this);
        }
    }
}
