/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.BookModel;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.datagen.DataGenerators;
import com.klikli_dev.modonomicon.integration.LecternIntegration;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.registry.CommandRegistry;
import com.klikli_dev.modonomicon.registry.CreativeModeTabRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="modonomicon")
public class ModonomiconForge {
    public ModonomiconForge(FMLJavaModLoadingContext context) {
        Modonomicon.init();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.get().spec);
        IEventBus modEventBus = context.getModEventBus();
        CreativeModeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(CreativeModeTabRegistry::onCreativeModeTabBuildContents);
        MinecraftForge.EVENT_BUS.addListener(e -> {
            BookDataManager.get().registries(e.getRegistries());
            e.addListener((PreparableReloadListener)BookDataManager.get());
            MultiblockDataManager.get().registries(e.getRegistries());
            e.addListener((PreparableReloadListener)MultiblockDataManager.get());
        });
        MinecraftForge.EVENT_BUS.addListener(e -> CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        MinecraftForge.EVENT_BUS.addListener(e -> CommandRegistry.registerClientCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() != null) {
                BookDataManager.get().onDatapackSync(e.getPlayer());
                MultiblockDataManager.get().onDatapackSync(e.getPlayer());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            Entity patt0$temp = e.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                BookUnlockStateManager.get().updateAndSyncFor(player);
                BookVisualStateManager.get().syncFor(player);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            Level level;
            LevelAccessor patt0$temp = e.getLevel();
            if (patt0$temp instanceof Level && (level = (Level)patt0$temp).dimension() == Level.OVERWORLD) {
                BookUnlockStateManager.get().saveData = null;
                BookVisualStateManager.get().saveData = null;
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onAdvancement((ServerPlayer)e.getEntity()));
        MinecraftForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onServerTickEnd(e.getServer()));
        modEventBus.addListener(DataGenerators::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(Client::onClientSetup);
            modEventBus.addListener(Client::onModifyBakingResult);
            modEventBus.addListener(e -> e.registerReloadListener((PreparableReloadListener)BookDataManager.Client.get()));
        }
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        Networking.registerMessages();
        LoaderRegistry.registerLoaders();
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternIntegration.rightClick(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.consumesAction()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
    }

    public static class Client {
        public static void onClientSetup(FMLClientSetupEvent event) {
            PageRendererRegistry.registerPageRenderers();
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.END) {
                    ClientTicks.endClientTick(Minecraft.getInstance());
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.START) {
                    ClientTicks.renderTickStart(e.getTimer().getGameTimeDeltaPartialTick(true));
                } else {
                    ClientTicks.renderTickEnd();
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result.consumesAction()) {
                    e.setCanceled(true);
                    e.setCancellationResult(result);
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.END) {
                    MultiblockPreviewRenderer.onClientTick(Minecraft.getInstance());
                }
            });
        }

        public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
            BookModel.replace(event.getResults().itemStackModels());
        }
    }
}

