/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BookCommand {
    protected ResourceLocation id;
    protected Book book;
    protected String command;
    protected int permissionLevel;
    protected int maxUses;
    @Nullable
    protected String failureMessage;
    @Nullable
    protected String successMessage;

    public BookCommand(ResourceLocation id, String command, int permissionLevel, int maxUses, @Nullable String failureMessage, @Nullable String successMessage) {
        this.id = id;
        this.command = command;
        this.permissionLevel = permissionLevel;
        this.maxUses = maxUses;
        this.failureMessage = failureMessage;
        this.successMessage = successMessage;
    }

    public static BookCommand fromJson(ResourceLocation id, JsonObject json) {
        String command = GsonHelper.getAsString((JsonObject)json, (String)"command");
        int permissionLevel = GsonHelper.getAsInt((JsonObject)json, (String)"permission_level", (int)0);
        int maxUses = GsonHelper.getAsInt((JsonObject)json, (String)"max_uses", (int)1);
        String failureMessage = GsonHelper.getAsString((JsonObject)json, (String)"failure_message", null);
        String successMessage = GsonHelper.getAsString((JsonObject)json, (String)"success_message", null);
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage);
    }

    public static BookCommand fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String command = buffer.readUtf();
        byte permissionLevel = buffer.readByte();
        int maxUses = buffer.readVarInt();
        String failureMessage = (String)buffer.readNullable(FriendlyByteBuf::readUtf);
        String successMessage = (String)buffer.readNullable(FriendlyByteBuf::readUtf);
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage);
    }

    public void build(Book book) {
        this.book = book;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.command);
        buffer.writeByte(this.permissionLevel);
        buffer.writeVarInt(this.maxUses);
        buffer.writeNullable((Object)this.failureMessage, FriendlyByteBuf::writeUtf);
        buffer.writeNullable((Object)this.successMessage, FriendlyByteBuf::writeUtf);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Nullable
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void execute(ServerPlayer player) {
        if (!BookUnlockStateManager.get().canRunFor((Player)player, this)) {
            String failureMessage = this.failureMessage == null ? "modonomicon.command.failure" : this.failureMessage;
            player.sendSystemMessage((Component)Component.translatable((String)failureMessage).withStyle(ChatFormatting.RED));
            return;
        }
        CommandSourceStack commandSourceStack = new CommandSourceStack(player.commandSource(), player.position(), player.getRotationVector(), player.serverLevel(), this.permissionLevel, player.getName().getString(), player.getDisplayName(), player.server, (Entity)player);
        BookUnlockStateManager.get().setRunFor((Player)player, this);
        try {
            player.server.getCommands().performPrefixedCommand(commandSourceStack, this.command);
            if (this.successMessage != null) {
                player.sendSystemMessage((Component)Component.translatable((String)this.successMessage).withStyle(ChatFormatting.GREEN));
            }
        }
        catch (Exception e) {
            Modonomicon.LOG.error("Running command [" + this.id.toString() + "] failed: ", (Throwable)e);
        }
        BookUnlockStateManager.get().syncFor(player);
    }
}

