/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BookIcon {
    public static final Codec<ItemStack> CUSTOM_ITEM_STACK_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Item.CODEC.fieldOf("item").forGetter(ItemStack::getItemHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)builder, ItemStack::new));
    public static final Codec<ItemStack> ITEM_STACK_CODEC = Codec.withAlternative(CUSTOM_ITEM_STACK_CODEC, (Codec)ItemStack.CODEC);
    private final ItemStack itemStack;
    private final ResourceLocation texture;
    private final int width;
    private final int height;

    public BookIcon(ItemStack stack) {
        this.itemStack = stack;
        this.texture = null;
        this.width = 16;
        this.height = 16;
    }

    public BookIcon(ResourceLocation texture, int width, int height) {
        this.texture = texture;
        this.itemStack = ItemStack.EMPTY;
        this.width = width;
        this.height = height;
    }

    public static BookIcon fromJson(JsonElement jsonElement, HolderLookup.Provider provider) {
        if (jsonElement.isJsonPrimitive()) {
            return BookIcon.fromString(ResourceLocation.parse((String)jsonElement.getAsString()));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("texture")) {
            int width = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"width", (int)16);
            int height = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"height", (int)16);
            ResourceLocation texture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"texture"));
            return new BookIcon(texture, width, height);
        }
        ItemStack stack = (ItemStack)((Pair)ITEM_STACK_CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonObject).getOrThrow(e -> {
            throw new JsonParseException("BookIcon must have either item or texture defined." + String.valueOf(jsonElement), new Throwable((String)e));
        })).getFirst();
        return new BookIcon(stack);
    }

    private static BookIcon fromString(ResourceLocation value) {
        if (value.getPath().endsWith(".png")) {
            return new BookIcon(value, 16, 16);
        }
        Item item = (Item)BuiltInRegistries.ITEM.getValue(value);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public static BookIcon fromNetwork(RegistryFriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            ResourceLocation texture = buffer.readResourceLocation();
            int width = buffer.readVarInt();
            int height = buffer.readVarInt();
            return new BookIcon(texture, width, height);
        }
        ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        return new BookIcon(stack);
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        if (this.texture != null) {
            guiGraphics.blit(RenderType::guiTextured, this.texture, x, y, 0.0f, 0.0f, 16, 16, this.width, this.height, this.width, this.height);
        } else {
            guiGraphics.renderItem(this.itemStack, x, y);
        }
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.texture != null);
        if (this.texture != null) {
            buffer.writeResourceLocation(this.texture);
            buffer.writeVarInt(this.width);
            buffer.writeVarInt(this.height);
        } else {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)this.itemStack);
        }
    }
}

